/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.rename;

import java.io.Serializable;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.AutoFocusSelectTextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(RenameDialog.class);
    private String name;
    private final IModelReference modelReference;

    public RenameDialog(IModelReference<Node> modelReference) {
        this.modelReference = modelReference;
        Node node = (Node)modelReference.getModel().getObject();
        if (node != null) {
            try {
                this.name = node.getName();
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        } else {
            this.setOkVisible(false);
        }
        this.add(new Component[]{new AutoFocusSelectTextFieldWidget("name", (IModel)new PropertyModel((Object)this, "name"))});
    }

    protected void onOk() {
        block6: {
            try {
                JcrNodeModel nodeModel = (JcrNodeModel)this.modelReference.getModel();
                if (nodeModel.getParentModel() == null) break block6;
                JcrNodeModel parentModel = nodeModel.getParentModel();
                Node parentNode = parentModel.getNode();
                String nextSiblingPath = parentNode.getPrimaryNodeType().hasOrderableChildNodes() ? this.findNextSiblingPath(nodeModel.getNode()) : null;
                String oldPath = nodeModel.getNode().getPath();
                String newPath = parentNode.getPath();
                if (!newPath.endsWith("/")) {
                    newPath = newPath + "/";
                }
                newPath = newPath + this.getName();
                Session jcrSession = UserSession.get().getJcrSession();
                jcrSession.move(oldPath, newPath);
                JcrNodeModel newNodeModel = new JcrNodeModel(parentModel.getNode().getNode(this.getName()));
                if (nextSiblingPath != null) {
                    String nextSiblingRelPath = StringUtils.substringAfterLast((String)nextSiblingPath, (String)"/");
                    try {
                        parentNode.orderBefore(this.getName(), nextSiblingRelPath);
                    }
                    catch (RepositoryException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                this.modelReference.setModel((IModel)newNodeModel);
            }
            catch (RepositoryException ex) {
                this.error((Serializable)((Object)ex.getMessage()));
            }
        }
    }

    protected String findNextSiblingPath(Node node) {
        try {
            Node parentNode = node.getParent();
            NodeIterator siblings = parentNode.getNodes();
            while (siblings.hasNext()) {
                if (!siblings.nextNode().isSame((Item)node)) continue;
                return siblings.hasNext() ? siblings.nextNode().getPath() : null;
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Rename Node"));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }
}

