/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.refs;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.plugins.console.menu.refs.ReferencesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencesDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(ReferencesDialog.class);

    public ReferencesDialog(final ReferencesPlugin plugin) {
        IModel nodeModel = plugin.getDefaultModel();
        this.setModel(nodeModel);
        this.add(new Component[]{new RefreshingView<Property>("references"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<Property>> getItemModels() {
                LinkedList<JcrPropertyModel> refModels = new LinkedList<JcrPropertyModel>();
                Node node = (Node)ReferencesDialog.this.getModelObject();
                try {
                    PropertyIterator refs = node.getReferences();
                    while (refs.hasNext()) {
                        refModels.add(new JcrPropertyModel(refs.nextProperty()));
                    }
                }
                catch (RepositoryException ex) {
                    log.error(ex.getMessage());
                }
                return refModels.iterator();
            }

            protected void populateItem(final Item<Property> item) {
                item.add(new Component[]{new Label("property", (IModel)new PropertyModel((Object)item.getModel(), "path"))});
                AjaxLink link = new AjaxLink("reference"){
                    private static final long serialVersionUID = 1L;

                    public void onClick(AjaxRequestTarget target) {
                        Property prop = (Property)item.getModelObject();
                        if (prop != null) {
                            try {
                                plugin.setModel((IModel)new JcrNodeModel(prop.getParent()));
                                ReferencesDialog.this.closeDialog();
                            }
                            catch (RepositoryException e) {
                                this.error((Serializable)((Object)e.getMessage()));
                                log.error(e.getMessage());
                            }
                        }
                    }
                };
                link.add(new Component[]{new Label("name", (IModel)new PropertyModel((Object)item.getModel(), "parent.name"))});
                item.add(new Component[]{link});
            }
        }});
    }

    public IValueMap getProperties() {
        return DialogConstants.LARGE;
    }

    public void onOk() {
    }

    public void onCancel() {
    }

    public IModel getTitle() {
        String path;
        IModel nodeModel = this.getModel();
        try {
            path = ((Node)nodeModel.getObject()).getPath();
        }
        catch (RepositoryException e) {
            path = e.getMessage();
            log.warn("Unable to get path for : " + nodeModel);
        }
        return new Model((Serializable)((Object)("References for " + path)));
    }
}

