/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.recompute;

import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.commons.iterator.NodeIterable;
import org.hippoecm.frontend.model.JcrHelper;
import org.hippoecm.repository.api.HippoNode;

public class RecomputeVisitor
implements ItemVisitor {
    private static final int BATCH_SIZE = 50;
    private int counter = 0;
    private boolean batchSave;

    RecomputeVisitor(boolean batchSave) {
        this.batchSave = batchSave;
    }

    public void visit(Property property) throws RepositoryException {
    }

    public void visit(Node node) throws RepositoryException {
        if (!JcrHelper.isVirtualNode((Node)node)) {
            if (node instanceof HippoNode && node.isNodeType("hippo:derived") && ((HippoNode)node).recomputeDerivedData()) {
                ++this.counter;
                this.saveIfNeeded(node.getSession());
            }
            for (Node child : new NodeIterable(node.getNodes())) {
                this.visit(child);
            }
        }
    }

    private void saveIfNeeded(Session session) throws RepositoryException {
        boolean shouldSave;
        boolean bl = shouldSave = this.batchSave && this.counter % 50 == 0;
        if (shouldSave) {
            session.save();
        }
    }
}

