/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.node;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.widgets.AutoCompleteTextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDialog
extends AbstractDialog<Node> {
    private static final Logger log = LoggerFactory.getLogger(NodeDialog.class);
    private String name;
    private String type;
    private final Map<String, Collection<String>> namesToTypes = new HashMap<String, Collection<String>>();
    private final Map<String, Collection<String>> typesToNames = new HashMap<String, Collection<String>>();
    private final IModelReference<Node> modelReference;
    private final TextField<String> typeField;
    private final TextField<String> nameField;

    public NodeDialog(IModelReference<Node> modelReference) {
        this.modelReference = modelReference;
        IModel nodeModel = modelReference.getModel();
        this.setModel(nodeModel);
        this.getParent().add(new Behavior[]{CssClass.append((String)"node-dialog")});
        Node node = (Node)nodeModel.getObject();
        try {
            NodeType pnt = node.getPrimaryNodeType();
            for (NodeDefinition nodeDefinition : pnt.getChildNodeDefinitions()) {
                if (nodeDefinition.isProtected()) continue;
                for (NodeType nodeType : nodeDefinition.getRequiredPrimaryTypes()) {
                    if (!nodeType.isAbstract()) {
                        this.addNodeType(nodeDefinition, nodeType);
                    }
                    for (NodeType subnt : this.getDescendantNodeTypes(nodeType)) {
                        this.addNodeType(nodeDefinition, subnt);
                    }
                }
            }
            for (NodeDefinition nodeDefinition : node.getMixinNodeTypes()) {
                for (NodeType nodeType : nodeDefinition.getChildNodeDefinitions()) {
                    if (nodeType.isProtected()) continue;
                    for (NodeType cnt : nodeType.getRequiredPrimaryTypes()) {
                        if (!cnt.isAbstract()) {
                            this.addNodeType((NodeDefinition)nodeType, cnt);
                        }
                        for (NodeType subnt : this.getDescendantNodeTypes(cnt)) {
                            this.addNodeType((NodeDefinition)nodeType, subnt);
                        }
                    }
                }
            }
        }
        catch (RepositoryException e) {
            log.warn("Unable to populate autocomplete list for child node names", (Throwable)e);
        }
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setAdjustInputWidth(false);
        settings.setUseSmartPositioning(true);
        settings.setShowCompleteListOnFocusGain(true);
        settings.setShowListOnEmptyInput(true);
        settings.setMaxHeightInPx(400);
        Model<String> typeModel = new Model<String>(){

            public String getObject() {
                Collection types;
                if (NodeDialog.this.name != null && NodeDialog.this.namesToTypes.containsKey(NodeDialog.this.name)) {
                    Collection types2 = (Collection)NodeDialog.this.namesToTypes.get(NodeDialog.this.name);
                    if (types2.size() == 1) {
                        NodeDialog.this.type = (String)types2.iterator().next();
                    }
                } else if (NodeDialog.this.namesToTypes.size() == 1 && (types = (Collection)NodeDialog.this.namesToTypes.values().iterator().next()).size() == 1) {
                    NodeDialog.this.type = (String)types.iterator().next();
                }
                return NodeDialog.this.type;
            }

            public void setObject(String s) {
                NodeDialog.this.type = s;
            }
        };
        this.typeField = new AutoCompleteTextFieldWidget<String>("type", (IModel)typeModel, settings){

            protected Iterator<String> getChoices(String input) {
                TreeSet result = new TreeSet();
                if (!Strings.isEmpty((CharSequence)NodeDialog.this.name)) {
                    if (NodeDialog.this.namesToTypes.get(NodeDialog.this.name) != null) {
                        result.addAll((Collection)NodeDialog.this.namesToTypes.get(NodeDialog.this.name));
                    }
                    if (NodeDialog.this.namesToTypes.get("*") != null) {
                        result.addAll((Collection)NodeDialog.this.namesToTypes.get("*"));
                    }
                } else {
                    NodeDialog.this.namesToTypes.values().forEach(result::addAll);
                }
                Iterator resultIter = result.iterator();
                while (resultIter.hasNext()) {
                    if (((String)resultIter.next()).contains(input)) continue;
                    resultIter.remove();
                }
                return result.iterator();
            }

            protected void onUpdate(AjaxRequestTarget target) {
                if (this.isVisibleInHierarchy()) {
                    target.add(new Component[]{NodeDialog.this.nameField});
                }
            }
        };
        this.typeField.setRequired(true);
        this.add(new Component[]{this.typeField});
        Model<String> nameModel = new Model<String>(){

            public String getObject() {
                String _name;
                Collection names;
                if (NodeDialog.this.type != null && NodeDialog.this.typesToNames.containsKey(NodeDialog.this.type)) {
                    String _name2;
                    Collection names2;
                    if (NodeDialog.this.name == null && (names2 = (Collection)NodeDialog.this.typesToNames.get(NodeDialog.this.type)).size() == 1 && !(_name2 = (String)names2.iterator().next()).equals("*")) {
                        NodeDialog.this.name = _name2;
                    }
                } else if (NodeDialog.this.typesToNames.size() == 1 && (names = (Collection)NodeDialog.this.typesToNames.values().iterator().next()).size() == 1 && !(_name = (String)names.iterator().next()).equals("*")) {
                    NodeDialog.this.name = _name;
                }
                return NodeDialog.this.name;
            }

            public void setObject(String s) {
                NodeDialog.this.name = s;
            }
        };
        this.nameField = new AutoCompleteTextFieldWidget<String>("name", (IModel)nameModel, settings){

            protected Iterator<String> getChoices(String input) {
                TreeSet<String> result = new TreeSet<String>();
                if (NodeDialog.this.type != null && !NodeDialog.this.type.isEmpty()) {
                    if (NodeDialog.this.typesToNames.get(NodeDialog.this.type) != null) {
                        result.addAll((Collection)NodeDialog.this.typesToNames.get(NodeDialog.this.type));
                    }
                } else {
                    for (String nodeName : NodeDialog.this.namesToTypes.keySet()) {
                        if (nodeName.equals("*") || !nodeName.contains(input)) continue;
                        result.add(nodeName);
                    }
                }
                return result.iterator();
            }

            protected void onUpdate(AjaxRequestTarget target) {
                if (this.isVisibleInHierarchy()) {
                    target.add(new Component[]{NodeDialog.this.typeField});
                }
            }
        };
        this.nameField.setRequired(true);
        this.add(new Component[]{this.setFocus((Component)this.nameField)});
    }

    public void onOk() {
        try {
            IModel nodeModel = this.getModel();
            Node node = ((Node)nodeModel.getObject()).addNode(this.name, this.type);
            this.modelReference.setModel((IModel)new JcrNodeModel(node));
        }
        catch (RepositoryException ex) {
            this.error((Serializable)((Object)ex.toString()));
        }
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Add a new Node"));
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }

    private Collection<NodeType> getDescendantNodeTypes(NodeType nt) {
        HashSet<NodeType> result = new HashSet<NodeType>();
        NodeTypeIterator subNodeTypes = nt.getDeclaredSubtypes();
        while (subNodeTypes.hasNext()) {
            NodeType subNodeType = subNodeTypes.nextNodeType();
            if (!subNodeType.isAbstract()) {
                result.add(subNodeType);
            }
            result.addAll(this.getDescendantNodeTypes(subNodeType));
        }
        return result;
    }

    private void addNodeType(NodeDefinition nd, NodeType nt) {
        Collection<String> types = this.namesToTypes.get(nd.getName());
        if (types == null) {
            types = new HashSet<String>(5);
            this.namesToTypes.put(nd.getName(), types);
        }
        types.add(nt.getName());
        Collection<String> names = this.typesToNames.get(nt.getName());
        if (names == null) {
            names = new HashSet<String>(5);
            this.typesToNames.put(nt.getName(), names);
        }
        names.add(nd.getName());
    }
}

