/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.namespace;

import java.io.Serializable;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.util.XMLChar;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.AjaxUpdatingWidget;
import org.hippoecm.frontend.widgets.RequiredTextFieldWidget;

public class NamespaceDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private String prefix;
    private String uri;

    public NamespaceDialog() {
        this.add(new Component[]{this.setFocus((AjaxUpdatingWidget)new RequiredTextFieldWidget("prefix", (IModel)new PropertyModel((Object)this, "prefix"), (IModel)new Model((Serializable)((Object)"namespace prefix"))))});
        this.add(new Component[]{new RequiredTextFieldWidget("uri", (IModel)new PropertyModel((Object)this, "uri"), (IModel)new Model((Serializable)((Object)"namespace uri")))});
    }

    protected void handleSubmit() {
        block8: {
            if (!this.isValidPrefix(this.prefix)) {
                return;
            }
            try {
                NamespaceRegistry namespaceRegistry = UserSession.get().getJcrSession().getWorkspace().getNamespaceRegistry();
                try {
                    String existingUri = namespaceRegistry.getURI(this.prefix);
                    if (this.uri.equals(existingUri)) {
                        this.info((Serializable)((Object)("namespace mapping '" + this.prefix + "' -> '" + this.uri + "' already exists")));
                        break block8;
                    }
                    this.error((Serializable)((Object)("prefix '" + this.prefix + "' is already mapped to uri '" + existingUri + "'")));
                }
                catch (NamespaceException e) {
                    try {
                        String existingPrefix = namespaceRegistry.getPrefix(this.uri);
                        this.error((Serializable)((Object)("uri '" + this.uri + "' is already mapped by prefix '" + existingPrefix + "'")));
                    }
                    catch (NamespaceException e1) {
                        namespaceRegistry.registerNamespace(this.prefix, this.uri);
                        this.closeDialog();
                    }
                }
            }
            catch (RepositoryException e) {
                this.error((Serializable)((Object)("Failed to register namespace: " + e.getMessage())));
            }
        }
    }

    private boolean isValidPrefix(String prefix) {
        if (prefix.toLowerCase().startsWith("xml")) {
            this.error((Serializable)((Object)"prefix should not start with 'xml'"));
            return false;
        }
        if (!XMLChar.isValidNCName((String)prefix)) {
            this.error((Serializable)((Object)"prefix contains invalid character"));
            return false;
        }
        return true;
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Add namespace"));
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }
}

