/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.move;

import java.io.Serializable;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.tree.IJcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNodeComparator;
import org.hippoecm.frontend.plugins.console.dialog.LookupDialog;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.AutoFocusSelectTextFieldWidget;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDialog
extends LookupDialog {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(MoveDialog.class);
    private String name;
    private String target;
    private Label targetLabel;
    private final IModelReference<Node> modelReference;

    public MoveDialog(IModelReference<Node> modelReference) {
        super(new JcrTreeNode((IModel)new JcrNodeModel("/"), null, (Comparator)new JcrTreeNodeComparator()), (IModel<Node>)modelReference.getModel());
        this.modelReference = modelReference;
        JcrNodeModel model = (JcrNodeModel)modelReference.getModel();
        try {
            if (model.getParentModel() != null) {
                this.setSelectedNode(model.getParentModel());
                this.add(new Component[]{new Label("source", model.getNode().getPath())});
                this.target = StringUtils.substringBeforeLast((String)model.getNode().getPath(), (String)"/") + "/";
                this.targetLabel = new Label("target", (IModel)new PropertyModel((Object)this, "target"));
                this.targetLabel.setOutputMarkupId(true);
                this.add(new Component[]{this.targetLabel});
                this.name = model.getNode().getName();
                AutoFocusSelectTextFieldWidget nameField = new AutoFocusSelectTextFieldWidget("name", (IModel)new PropertyModel((Object)this, "name"));
                nameField.setSize(String.valueOf(this.name.length() + 5));
                this.add(new Component[]{nameField});
            } else {
                this.add(new Component[]{new Label("source", "Cannot move the root node")});
                this.add(new Component[]{new EmptyPanel("target")});
                this.add(new Component[]{new EmptyPanel("name")});
                this.setOkVisible(false);
                this.setFocusOnCancel();
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            this.add(new Component[]{new Label("source", ((Object)((Object)e)).getClass().getName())});
            this.add(new Component[]{new Label("target", e.getMessage())});
            this.add(new Component[]{new EmptyPanel("name")});
            this.setOkVisible(false);
            this.setFocusOnCancel();
        }
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Move Node"));
    }

    @Override
    public void onSelect(IModel<Node> model) {
        AjaxRequestTarget requestTarget;
        if (model != null) {
            try {
                this.target = ((Node)model.getObject()).getPath() + "/";
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        if ((requestTarget = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)) != null) {
            requestTarget.add(new Component[]{this.targetLabel});
        }
    }

    @Override
    protected boolean isValidSelection(IJcrTreeNode targetModel) {
        return true;
    }

    public void onOk() {
        Node sourceNode = (Node)this.getOriginalModel().getObject();
        Node parentNode = this.getParentDestNode();
        if (Strings.isEmpty((CharSequence)this.name) || parentNode == null || sourceNode == null) {
            return;
        }
        try {
            String targetPath = parentNode.getPath();
            if (!targetPath.endsWith("/")) {
                targetPath = targetPath + "/";
            }
            targetPath = targetPath + this.name;
            Session jcrSession = UserSession.get().getJcrSession();
            jcrSession.move(sourceNode.getPath(), targetPath);
            Node targetNode = JcrUtils.getNodeIfExists((String)targetPath, (Session)jcrSession);
            if (targetNode != null) {
                this.modelReference.setModel((IModel)new JcrNodeModel(targetNode));
            }
        }
        catch (RepositoryException ex) {
            this.error((Serializable)((Object)ex.getMessage()));
        }
    }

    private Node getParentDestNode() {
        IJcrTreeNode selectedTreeNode = this.getSelectedNode();
        if (selectedTreeNode == null || selectedTreeNode.getNodeModel() == null) {
            return null;
        }
        return (Node)selectedTreeNode.getNodeModel().getObject();
    }
}

