/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.deletemultiple;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.extensions.markup.html.tree.table.IColumn;
import org.apache.wicket.extensions.markup.html.tree.table.PropertyTreeColumn;
import org.apache.wicket.extensions.markup.html.tree.table.TreeTable;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.tree.JcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNodeComparator;
import org.hippoecm.frontend.plugins.console.NodeModelReference;
import org.hippoecm.frontend.plugins.console.browser.NodeIconUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteMultipleDialog
extends AbstractDialog<Node> {
    private static final Logger log = LoggerFactory.getLogger(DeleteMultipleDialog.class);
    private static final long serialVersionUID = 1L;
    private NodeModelReference modelReference;
    private final TreeTable tree;
    private IModel<Node> selectedModel;
    private IModel<Boolean> checkboxModel;

    public DeleteMultipleDialog(NodeModelReference modelReference) {
        this.modelReference = modelReference;
        DefaultTreeModel model = null;
        try {
            this.selectedModel = modelReference.getModel();
            JcrTreeNode root = new JcrTreeNode((IModel)new JcrNodeModel(((Node)this.selectedModel.getObject()).getPath()), null, (Comparator)new JcrTreeNodeComparator());
            model = new DefaultTreeModel((TreeNode)root);
        }
        catch (RepositoryException e) {
            log.error("Error initializing tree", (Throwable)e);
        }
        IColumn[] columns = new IColumn[]{new PropertyTreeColumn(new ColumnLocation(ColumnLocation.Alignment.MIDDLE, 8, ColumnLocation.Unit.PROPORTIONAL), "Name", "nodeModel.node.name")};
        this.tree = new TreeTable("multitree", model, columns){

            protected Component newNodeIcon(MarkupContainer parent, String id, TreeNode node) {
                return NodeIconUtils.createJcrNodeIcon(id, node);
            }
        };
        this.tree.getTreeState().setAllowSelectMultiple(true);
        this.add(new Component[]{this.tree});
        if (model != null) {
            this.tree.getTreeState().expandNode(model.getRoot());
        }
        this.checkboxModel = Model.of((Serializable)Boolean.FALSE);
        this.add(new Component[]{new CheckBox("deleteFolders", this.checkboxModel)});
    }

    protected void onOk() {
        Collection selectedNodes = this.tree.getTreeState().getSelectedNodes();
        if (this.rootSelected(selectedNodes)) {
            this.error((Serializable)((Object)"You've selected root node for deletion"));
            return;
        }
        boolean deleteFolders = this.checkboxModel.getObject() == null ? false : (Boolean)this.checkboxModel.getObject();
        for (Object selectedNode : selectedNodes) {
            JcrTreeNode deleteNode = (JcrTreeNode)selectedNode;
            IModel nodeModel = deleteNode.getChainedModel();
            Node node = (Node)nodeModel.getObject();
            if (node == null) continue;
            try {
                if (node.getNodes().hasNext()) {
                    if (!deleteFolders) continue;
                    node.remove();
                    continue;
                }
                node.remove();
            }
            catch (RepositoryException e) {
                if (!log.isDebugEnabled()) continue;
                log.error("Error removing node:", (Throwable)e);
            }
        }
        this.modelReference.setModel(this.selectedModel);
    }

    private boolean rootSelected(Iterable<Object> selectedNodes) {
        for (Object selectedNode : selectedNodes) {
            JcrTreeNode deleteNode = (JcrTreeNode)selectedNode;
            IModel nodeModel = deleteNode.getChainedModel();
            if (!nodeModel.equals(this.selectedModel)) continue;
            return true;
        }
        return false;
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Delete multiple nodes"));
    }

    public IValueMap getProperties() {
        return new ValueMap("width=640,height=650").makeImmutable();
    }
}

