/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.copy;

import java.io.Serializable;
import java.util.Comparator;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.tree.IJcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNodeComparator;
import org.hippoecm.frontend.plugins.console.dialog.LookupDialog;
import org.hippoecm.frontend.plugins.console.menu.t9ids.GenerateNewTranslationIdsVisitor;
import org.hippoecm.frontend.widgets.AutoFocusSelectTextFieldWidget;
import org.hippoecm.frontend.widgets.LabelledBooleanFieldWidget;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyDialog
extends LookupDialog {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(CopyDialog.class);
    private static final IValueMap SIZE = new ValueMap("width=515,height=540");
    private String name;
    private Boolean generate = true;
    private String target;
    private Label targetLabel;
    private final IModelReference<Node> modelReference;

    public CopyDialog(IModelReference<Node> modelReference) {
        super(new JcrTreeNode((IModel)new JcrNodeModel("/"), null, (Comparator)new JcrTreeNodeComparator()), (IModel<Node>)modelReference.getModel());
        this.modelReference = modelReference;
        JcrNodeModel model = (JcrNodeModel)modelReference.getModel();
        this.setSelectedNode(model);
        try {
            if (model.getParentModel() != null) {
                this.setSelectedNode(model.getParentModel());
                this.add(new Component[]{new Label("source", model.getNode().getPath())});
                this.target = StringUtils.substringBeforeLast((String)model.getNode().getPath(), (String)"/") + "/";
                this.targetLabel = new Label("target", (IModel)new PropertyModel((Object)this, "target"));
                this.targetLabel.setOutputMarkupId(true);
                this.add(new Component[]{this.targetLabel});
                this.name = model.getNode().getName();
                AutoFocusSelectTextFieldWidget nameField = new AutoFocusSelectTextFieldWidget("name", (IModel)new PropertyModel((Object)this, "name"));
                nameField.setSize(String.valueOf(this.name.length() + 5));
                this.add(new Component[]{nameField});
                LabelledBooleanFieldWidget checkbox = new LabelledBooleanFieldWidget("generate", (IModel)new PropertyModel((Object)this, "generate"), (IModel)Model.of((Serializable)((Object)"Generate new translation ids")));
                this.add(new Component[]{checkbox});
            } else {
                this.add(new Component[]{new Label("source", "Cannot copy the root node")});
                this.add(new Component[]{new EmptyPanel("target")});
                this.add(new Component[]{new EmptyPanel("name")});
                this.add(new Component[]{new EmptyPanel("generate")});
                this.setOkVisible(false);
                this.setFocusOnCancel();
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            this.add(new Component[]{new Label("source", ((Object)((Object)e)).getClass().getName())});
            this.add(new Component[]{new Label("target", e.getMessage())});
            this.add(new Component[]{new EmptyPanel("name")});
            this.setOkVisible(false);
            this.setFocusOnCancel();
        }
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Copy Node"));
    }

    @Override
    public void onSelect(IModel<Node> model) {
        AjaxRequestTarget requestTarget;
        if (model != null) {
            try {
                this.target = ((Node)model.getObject()).getPath() + "/";
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        if ((requestTarget = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)) != null) {
            requestTarget.add(new Component[]{this.targetLabel});
        }
    }

    @Override
    protected boolean isValidSelection(IJcrTreeNode targetModel) {
        return true;
    }

    public void onOk() {
        if (Strings.isEmpty((CharSequence)this.name)) {
            return;
        }
        Node sourceNode = (Node)this.getOriginalModel().getObject();
        if (sourceNode == null) {
            return;
        }
        try {
            Node parentNode = this.getParentDestNode();
            if (parentNode == null) {
                return;
            }
            JcrUtils.copy((Node)sourceNode, (String)this.name, (Node)parentNode);
            Node targetNode = JcrUtils.getNodeIfExists((Node)parentNode, (String)this.name);
            if (targetNode != null) {
                if (this.generate.booleanValue()) {
                    targetNode.accept((ItemVisitor)new GenerateNewTranslationIdsVisitor());
                }
                this.modelReference.setModel((IModel)new JcrNodeModel(targetNode));
            }
        }
        catch (IllegalArgumentException | RepositoryException ex) {
            log.error(ex.getMessage());
            this.error((Serializable)((Object)ex.getMessage()));
        }
    }

    private Node getParentDestNode() throws RepositoryException {
        IJcrTreeNode selectedTreeNode = this.getSelectedNode();
        if (selectedTreeNode == null || selectedTreeNode.getNodeModel() == null) {
            return null;
        }
        Node parentNode = (Node)selectedTreeNode.getNodeModel().getObject();
        String[] elements = this.name.split("/");
        for (int i = 0; i < elements.length - 1; ++i) {
            if (!parentNode.hasNode(elements[i])) {
                throw new RepositoryException("No such destination: " + parentNode.getPath() + "/" + elements[i]);
            }
            parentNode = parentNode.getNode(elements[i]);
        }
        return parentNode;
    }

    @Override
    public IValueMap getProperties() {
        return SIZE;
    }
}

