/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.content;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugins.console.menu.t9ids.GenerateNewTranslationIdsVisitor;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.LabelledBooleanFieldWidget;
import org.hippoecm.repository.api.HippoSession;
import org.onehippo.repository.util.ZipFileContentResourceLoader;
import org.onehippo.repository.xml.ContentResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentImportDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContentImportDialog.class);
    private final LookupHashMap<Integer, String> uuidOpts = new LookupHashMap();
    private final LookupHashMap<Integer, String> derefOpts = new LookupHashMap();
    private final JcrNodeModel nodeModel;
    private FileUploadField fileUploadField;
    private String xmlInput;
    private Boolean saveBehavior = false;
    private Boolean generate = false;
    private String uuidBehavior = "Create new uuids on import";
    private String derefBehavior = "Throw error when not found";

    private void InitMaps() {
        this.uuidOpts.put(1, "Remove existing node with same uuid");
        this.uuidOpts.put(2, "Replace existing node with same uuid");
        this.uuidOpts.put(3, "Throw error on uuid collision");
        this.uuidOpts.put(0, "Create new uuids on import");
        this.derefOpts.put(0, "Remove reference when not found");
        this.derefOpts.put(2, "Throw error when not found");
        this.derefOpts.put(1, "Add reference to root node when not found");
    }

    public ContentImportDialog(IModelReference<Node> modelReference) {
        this.InitMaps();
        this.nodeModel = (JcrNodeModel)modelReference.getModel();
        DropDownChoice uuid = new DropDownChoice("uuidBehaviors", (IModel)new PropertyModel((Object)this, "uuidBehavior"), new ArrayList(this.uuidOpts.values()));
        DropDownChoice reference = new DropDownChoice("derefBehaviors", (IModel)new PropertyModel((Object)this, "derefBehavior"), new ArrayList(this.derefOpts.values()));
        LabelledBooleanFieldWidget save = new LabelledBooleanFieldWidget("saveBehavior", (IModel)new PropertyModel((Object)this, "saveBehavior"), (IModel)Model.of((Serializable)((Object)"Immediate save after import")));
        this.add(new Component[]{uuid.setNullValid(false).setRequired(true)});
        this.add(new Component[]{reference.setNullValid(false).setRequired(true)});
        this.add(new Component[]{save});
        LabelledBooleanFieldWidget generate = new LabelledBooleanFieldWidget("generate", (IModel)new PropertyModel((Object)this, "generate"), (IModel)Model.of((Serializable)((Object)"Generate new translation ids (only when adding a node)")));
        this.add(new Component[]{generate});
        this.setMultiPart(true);
        this.setNonAjaxSubmit();
        Component[] componentArray = new Component[1];
        this.fileUploadField = new FileUploadField("fileInput");
        componentArray[0] = this.fileUploadField;
        this.add(componentArray);
        this.add(new Component[]{new TextArea("xmlInput", (IModel)new PropertyModel((Object)this, "xmlInput"))});
        this.setOkLabel("Import");
        this.setFocus((Component)uuid);
        try {
            String path = this.nodeModel.getNode().getPath();
            this.add(new Component[]{new Label("message", (IModel)new StringResourceModel("dialog.message", (Component)this, null, null, new Object[]{path}))});
        }
        catch (RepositoryException e) {
            log.error("Error getting node from model for contant import", (Throwable)e);
            throw new RuntimeException("Error getting node from model for contant import: " + e.getMessage());
        }
    }

    public IModel<String> getTitle() {
        return new Model((Serializable)((Object)"XML Import"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void onOk() {
        upload = this.fileUploadField.getFileUpload();
        uuidOpt = this.uuidOpts.getFirstKey(this.uuidBehavior);
        derefOpt = this.derefOpts.getFirstKey(this.derefBehavior);
        try {
            block26: {
                block28: {
                    block24: {
                        block25: {
                            if (upload == null && StringUtils.isEmpty((String)this.xmlInput)) {
                                this.warn((Serializable)"No file was uploaded and no xml input provided. Nothing to import");
                                return;
                            }
                            absPath = this.nodeModel.getNode().getPath();
                            if (this.saveBehavior.booleanValue()) {
                                this.nodeModel.getNode().getSession().save();
                            }
                            tempFile = null;
                            zipFile = null;
                            in /* !! */  = null;
                            esvIn = null;
                            out = null;
                            try {
                                session = (HippoSession)UserSession.get().getJcrSession();
                                nodesBefore = new ArrayList<String>();
                                if (this.generate.booleanValue()) {
                                    nodeIterator = this.nodeModel.getNode().getNodes();
                                    while (nodeIterator.hasNext()) {
                                        node = nodeIterator.nextNode();
                                        nodesBefore.add(node.getPath());
                                    }
                                }
                                if (upload == null) ** GOTO lbl81
                                fileName = upload.getClientFileName();
                                if (fileName.endsWith(".zip")) {
                                    tempFile = File.createTempFile("package", "zip");
                                    out = new FileOutputStream(tempFile);
                                    in /* !! */  = upload.getInputStream();
                                    IOUtils.copy((InputStream)in /* !! */ , (OutputStream)out);
                                    out.close();
                                    out = null;
                                    zipFile = new ZipFile(tempFile);
                                    contentResourceLoader = new ZipFileContentResourceLoader(zipFile);
                                    esvIn = contentResourceLoader.getResourceAsStream("esv.xml");
                                    session.importEnhancedSystemViewXML(absPath, esvIn, uuidOpt, derefOpt, (ContentResourceLoader)contentResourceLoader);
                                    break block24;
                                }
                                if (fileName.endsWith(".xml")) {
                                    in /* !! */  = new BufferedInputStream(upload.getInputStream());
                                    session.importEnhancedSystemViewXML(absPath, (InputStream)in /* !! */ , uuidOpt, derefOpt, null);
                                    break block24;
                                }
                                this.warn((Serializable)"Unrecognized file: only .xml and .zip can be processed");
                                if (!this.saveBehavior.booleanValue()) break block25;
                            }
                            catch (Throwable var14_18) {
                                if (this.saveBehavior.booleanValue()) {
                                    this.nodeModel.getNode().getSession().refresh(false);
                                }
                                IOUtils.closeQuietly(out);
                                IOUtils.closeQuietly(esvIn);
                                IOUtils.closeQuietly(in /* !! */ );
                                if (zipFile != null) {
                                    try {
                                        zipFile.close();
                                    }
                                    catch (Exception var15_19) {
                                        // empty catch block
                                    }
                                }
                                FileUtils.deleteQuietly(tempFile);
                                throw var14_18;
                            }
                            this.nodeModel.getNode().getSession().refresh(false);
                        }
                        IOUtils.closeQuietly((OutputStream)out);
                        IOUtils.closeQuietly(esvIn);
                        IOUtils.closeQuietly((InputStream)in /* !! */ );
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (Exception var13_17) {
                                // empty catch block
                            }
                        }
                        FileUtils.deleteQuietly((File)tempFile);
                        return;
                    }
                    break block28;
lbl81:
                    // 1 sources

                    in /* !! */  = new ByteArrayInputStream(this.xmlInput.getBytes("UTF-8"));
                    session.importEnhancedSystemViewXML(absPath, (InputStream)in /* !! */ , uuidOpt, derefOpt, null);
                }
                if (this.generate.booleanValue() && (newNode = this.findNewNode(nodesBefore, this.nodeModel.getNode())) != null) {
                    ContentImportDialog.log.debug("Applying new translation ids on node: " + newNode.getPath());
                    newNode.accept((ItemVisitor)new GenerateNewTranslationIdsVisitor());
                }
                if (this.saveBehavior.booleanValue()) {
                    this.nodeModel.getNode().getSession().save();
                }
                if (!this.saveBehavior.booleanValue()) break block26;
                this.nodeModel.getNode().getSession().refresh(false);
            }
            IOUtils.closeQuietly((OutputStream)out);
            IOUtils.closeQuietly(esvIn);
            IOUtils.closeQuietly((InputStream)in /* !! */ );
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception var10_13) {
                    // empty catch block
                }
            }
            FileUtils.deleteQuietly((File)tempFile);
        }
        catch (RepositoryException ex) {
            ContentImportDialog.log.error("Error initializing content in '" + this.nodeModel.getItemModel().getPath() + "' : " + ex.getMessage(), (Throwable)ex);
            this.error((Serializable)("Import failed: " + ex.getMessage()));
        }
        catch (IOException ex) {
            ContentImportDialog.log.error("IOException initializing content in '" + this.nodeModel.getItemModel().getPath() + "' : " + ex.getMessage(), (Throwable)ex);
            this.error((Serializable)("Import failed: " + ex.getMessage()));
        }
    }

    private Node findNewNode(List<String> nodesBefore, Node node) throws RepositoryException {
        NodeIterator nodesAfter = node.getNodes();
        while (nodesAfter.hasNext()) {
            Node afterNode = nodesAfter.nextNode();
            if (nodesBefore.contains(afterNode.getPath())) continue;
            return afterNode;
        }
        return null;
    }

    public void setDerefBehavior(String derefBehavior) {
        this.derefBehavior = derefBehavior;
    }

    public String getDerefBehavior() {
        return this.derefBehavior;
    }

    public void setUuidBehavior(String uuidBehavior) {
        this.uuidBehavior = uuidBehavior;
    }

    public String getUuidBehavior() {
        return this.uuidBehavior;
    }

    public void setSaveBehavior(boolean saveBehavior) {
        this.saveBehavior = saveBehavior;
    }

    public boolean getSaveBehavior() {
        return this.saveBehavior;
    }

    public String getXmlInput() {
        return this.xmlInput;
    }

    public void setXmlInput(String xmlInput) {
        this.xmlInput = xmlInput;
    }

    public IValueMap getProperties() {
        return new ValueMap("width=855,height=460").makeImmutable();
    }

    public class LookupHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 9065806784464553409L;

        public K getFirstKey(Object value) {
            if (value == null) {
                return null;
            }
            for (Map.Entry e : this.entrySet()) {
                if (!value.equals(e.getValue())) continue;
                return e.getKey();
            }
            return null;
        }
    }
}

