/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.cnd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.download.DownloadLink;
import org.hippoecm.repository.util.JcrCompactNodeTypeDefWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CndExportDialog
extends AbstractDialog<Void> {
    private static final Logger log = LoggerFactory.getLogger(CndExportDialog.class);
    private static final long serialVersionUID = 1L;
    private String selectedNs;

    public CndExportDialog() {
        PropertyModel selectedNsModel = new PropertyModel((Object)this, "selectedNs");
        List<String> nsPrefixes = null;
        try {
            Session session = this.getJcrSession();
            nsPrefixes = this.getNsPrefixes(session);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        final Label dump = new Label("dump");
        dump.setOutputMarkupId(true);
        this.add(new Component[]{dump});
        DropDownChoice<String> dropdown = new DropDownChoice<String>("nsprefixes", (IModel)selectedNsModel, nsPrefixes){
            private static final long serialVersionUID = 1L;

            public boolean isNullValid() {
                return false;
            }

            public boolean isRequired() {
                return false;
            }
        };
        this.add(new Component[]{dropdown});
        dropdown.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                String export;
                try {
                    Session session = CndExportDialog.this.getJcrSession();
                    export = JcrCompactNodeTypeDefWriter.compactNodeTypeDef((Workspace)session.getWorkspace(), (String)CndExportDialog.this.selectedNs);
                }
                catch (RepositoryException e) {
                    log.error("RepositoryException while exporting NodeType Definitions of namespace : " + CndExportDialog.this.selectedNs, (Throwable)e);
                    export = e.getMessage();
                }
                catch (IOException e) {
                    log.error("IOException while exporting NodeType Definitions of namespace : " + CndExportDialog.this.selectedNs, (Throwable)e);
                    export = e.getMessage();
                }
                dump.setDefaultModel((IModel)new Model((Serializable)((Object)export)));
                target.add(new Component[]{CndExportDialog.this});
            }
        }});
        DownloadLink<Node> link = new DownloadLink<Node>("download-link"){
            private static final long serialVersionUID = 1L;

            protected String getFilename() {
                return CndExportDialog.this.selectedNs + ".cnd";
            }

            protected InputStream getContent() {
                String export = (String)dump.getDefaultModel().getObject();
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                PrintWriter writer = new PrintWriter(ostream);
                writer.print(export);
                writer.flush();
                return new ByteArrayInputStream(ostream.toByteArray());
            }

            public boolean isVisible() {
                return CndExportDialog.this.selectedNs != null && !dump.getDefaultModelObjectAsString().equals("");
            }
        };
        link.add(new Component[]{new Label("download-link-text", "Download (or right click and choose \"Save as..\"")});
        link.setOutputMarkupId(true);
        this.add(new Component[]{link});
        this.setOkVisible(false);
    }

    public String getSelectedNs() {
        return this.selectedNs;
    }

    public void setSelectedNs(String ns) {
        this.selectedNs = ns;
    }

    private Session getJcrSession() {
        return UserSession.get().getJcrSession();
    }

    public IModel<String> getTitle() {
        return new Model((Serializable)((Object)"Export CND of namespace"));
    }

    private List<String> getNsPrefixes(Session session) throws RepositoryException {
        ArrayList<String> nsPrefixes = new ArrayList<String>();
        String[] ns = session.getNamespacePrefixes();
        for (int i = 0; i < ns.length; ++i) {
            if ("".equals(ns[i])) continue;
            nsPrefixes.add(ns[i]);
        }
        Collections.sort(nsPrefixes);
        return nsPrefixes;
    }
}

