/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu;

import java.io.Serializable;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.wicket.Component;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckPlugin
extends RenderPlugin {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(CheckPlugin.class);

    public CheckPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        Component[] componentArray = new Component[1];
        final Label message = new Label("message", (IModel)new Model((Serializable)((Object)"")));
        componentArray[0] = message;
        this.add(componentArray);
        message.setOutputMarkupId(true);
        this.add(new Component[]{new AjaxLink("check-link"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                String result = CheckPlugin.this.check();
                message.setDefaultModel((IModel)new Model((Serializable)((Object)result)));
                this.setModel((IModel)new Model((Serializable)((Object)result)));
                target.add(new Component[]{message});
            }
        }});
        UserSession session = this.getSession();
        if (session.getApplication().getConfigurationType().equals((Object)RuntimeConfigurationType.DEPLOYMENT)) {
            this.setVisible(false);
        }
    }

    private String check() {
        Session session;
        try {
            session = this.getSession().getJcrSession();
            this.check(session);
        }
        catch (RepositoryException ex) {
            log.error("error during user consistency check", (Throwable)ex);
            return "error";
        }
        try {
            session = this.getSession().getJcrSession().getRepository().login((Credentials)new SimpleCredentials("admin", "admin".toCharArray()));
            this.check(session);
            session.logout();
        }
        catch (RepositoryException ex) {
            log.error("error during root consistency check", (Throwable)ex);
            return "Error";
        }
        return null;
    }

    private void check(Session session) throws RepositoryException {
        this.check(session.getRootNode());
        Query query = session.getWorkspace().getQueryManager().createQuery("//element(*,nt:base)", "xpath");
        QueryResult result = query.execute();
        NodeIterator iter = result.getNodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node == null || !log.isTraceEnabled()) continue;
            log.trace("query: {}", (Object)node.getPath());
        }
    }

    private void check(Node node) throws RepositoryException {
        HippoNode hippoNode;
        if (log.isTraceEnabled()) {
            log.trace("traverse: {}", (Object)node.getPath());
        }
        if (node instanceof HippoNode && (hippoNode = (HippoNode)node).isVirtual()) {
            return;
        }
        if (node.getPath().equals("/jcr:system")) {
            return;
        }
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            if (child == null) continue;
            this.check(child);
        }
        iter = node.getProperties();
        while (iter.hasNext()) {
            iter.nextProperty();
        }
    }
}

