/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.io.Serializable;
import java.util.regex.Pattern;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.plugins.console.editor.EditorPlugin;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.TextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReferenceEditor
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final Logger log = LoggerFactory.getLogger(ReferenceEditor.class);

    ReferenceEditor(String id, JcrPropertyModel propertyModel, JcrPropertyValueModel<String> valueModel) {
        super(id, valueModel);
        this.setOutputMarkupId(true);
        final ReferenceLink referenceLink = new ReferenceLink("reference-link", (IModel<String>)valueModel);
        this.add(new Component[]{referenceLink});
        try {
            if (propertyModel.getProperty().getDefinition().isProtected()) {
                this.add(new Component[]{new Label("reference-edit", (String)((Object)valueModel.getObject()))});
            } else {
                TextFieldWidget editor = new TextFieldWidget("reference-edit", (IModel)valueModel){

                    protected void onUpdate(AjaxRequestTarget target) {
                        referenceLink.load();
                        target.add(new Component[]{ReferenceEditor.this});
                    }
                };
                editor.setSize("40");
                this.add(new Component[]{editor});
            }
        }
        catch (RepositoryException e) {
            this.addOrReplace(new Component[]{new Label("reference-edit", ((Object)((Object)e)).getClass().getName())});
            this.addOrReplace(new Component[]{new ExceptionLink("reference-link", (IModel)Model.of((Serializable)((Object)e.getMessage())))});
        }
    }

    private static class ExceptionLink
    extends AjaxLink {
        private static final long serialVersionUID = 1L;

        public ExceptionLink(String id, IModel linktext) {
            super(id);
            this.setEnabled(false);
            this.add(new Component[]{new Label("reference-link-text", linktext)});
            this.add(new Behavior[]{new AttributeAppender("style", (IModel)Model.of((Serializable)((Object)"color:red")), " ")});
        }

        public void onClick(AjaxRequestTarget target) {
        }
    }

    private static class ReferenceLink
    extends AjaxLink<String> {
        private static final long serialVersionUID = 1L;
        private static Pattern JCR_IDENTIFIER = Pattern.compile("^\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}$");
        private static Pattern COMMA_SEPARATED_JCR_IDENTIFIERS = Pattern.compile("^(\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12},)*\\w{8}-\\w{4}-\\w{4}-\\w{4}-\\w{12}$");
        private String linkText = null;
        private JcrNodeModel linkModel = null;
        private boolean isValidLink = false;

        public ReferenceLink(String id, IModel<String> valueModel) {
            super(id, valueModel);
            this.load();
            this.add(new Component[]{new Label("reference-link-text", (IModel)new PropertyModel((Object)this, "linkText"))});
            if (this.isValidLink()) {
                this.add(new Behavior[]{CssClass.append((String)"message")});
            } else {
                this.add(new Behavior[]{CssClass.append((String)"error")});
            }
        }

        protected boolean isLinkEnabled() {
            return this.linkModel != null;
        }

        private boolean isValidLink() {
            return this.isValidLink;
        }

        private void load() {
            this.linkText = null;
            this.linkModel = null;
            this.isValidLink = false;
            String uuid = (String)this.getModelObject();
            if (JCR_IDENTIFIER.matcher(uuid).matches()) {
                try {
                    Session session = UserSession.get().getJcrSession();
                    Node targetNode = session.getNodeByIdentifier(uuid);
                    this.linkText = targetNode.getPath();
                    this.linkModel = new JcrNodeModel(targetNode);
                    this.isValidLink = true;
                }
                catch (ItemNotFoundException e) {
                    this.linkText = this.getString("reference.editor.input.not.found");
                }
                catch (RepositoryException e) {
                    this.linkText = this.getString("reference.editor.input.error");
                    log.error("Error loading node with uuid " + uuid, (Throwable)e);
                }
            } else if (COMMA_SEPARATED_JCR_IDENTIFIERS.matcher(uuid).matches()) {
                this.linkText = this.getString("reference.editor.input.multiple.identifiers");
                this.isValidLink = true;
            } else {
                this.linkText = this.getString("reference.editor.input.invalid");
            }
        }

        public void onClick(AjaxRequestTarget target) {
            if (this.linkModel != null) {
                ((EditorPlugin)((Object)this.findParent(EditorPlugin.class))).setDefaultModel((IModel)this.linkModel);
            }
        }

        protected void onDetach() {
            if (this.linkModel != null) {
                this.linkModel.detach();
            }
            super.onDetach();
        }
    }
}

