/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.DateConverter;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.model.properties.StringConverter;
import org.hippoecm.frontend.plugins.console.editor.BinaryEditor;
import org.hippoecm.frontend.plugins.console.editor.EditorPlugin;
import org.hippoecm.frontend.plugins.console.editor.NodeEditor;
import org.hippoecm.frontend.plugins.console.editor.ValueEditorFactory;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.widgets.AjaxUpdatingWidget;
import org.hippoecm.frontend.widgets.BooleanFieldWidget;
import org.hippoecm.frontend.widgets.TextAreaWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyValueEditor
extends DataView {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PropertyValueEditor.class);
    protected static final int TEXT_AREA_MAX_COLUMNS = 100;
    private JcrPropertyModel propertyModel;
    private final DateConverter dateConverter = new ISO8601DateConverter();
    private boolean focusOnLastItem;

    PropertyValueEditor(String id, JcrPropertyModel dataProvider) {
        super(id, (IDataProvider)dataProvider);
        this.propertyModel = dataProvider;
        this.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
    }

    protected void populateItem(Item item) {
        try {
            final JcrPropertyValueModel valueModel = (JcrPropertyValueModel)item.getModel();
            Component valueEditor = this.createValueEditor(valueModel);
            item.add(new Component[]{valueEditor});
            AjaxLink removeLink = new AjaxLink("remove"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        Property prop = PropertyValueEditor.this.propertyModel.getProperty();
                        Object[] values = prop.getValues();
                        values = (Value[])ArrayUtils.remove((Object[])values, (int)valueModel.getIndex());
                        prop.getParent().setProperty(prop.getName(), (Value[])values, prop.getType());
                    }
                    catch (RepositoryException e) {
                        log.error(e.getMessage());
                    }
                    NodeEditor editor = (NodeEditor)((Object)this.findParent(NodeEditor.class));
                    if (editor != null) {
                        target.add(new Component[]{editor});
                    }
                }
            };
            removeLink.add(new Behavior[]{TitleAttribute.set((String)this.getString("property.value.remove"))});
            PropertyDefinition definition = this.propertyModel.getProperty().getDefinition();
            removeLink.setVisible(definition.isMultiple() && !definition.isProtected());
            item.add(new Component[]{removeLink});
            if (this.focusOnLastItem && (long)item.getIndex() == this.getItemCount() - 1L) {
                this.focusOnLastItem = false;
                AjaxRequestTarget ajax = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                if (ajax != null && valueEditor instanceof AjaxUpdatingWidget) {
                    ajax.focusComponent(((AjaxUpdatingWidget)valueEditor).getFocusComponent());
                }
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            item.add(new Component[]{new Label("value", ((Object)((Object)e)).getClass().getName() + ":" + e.getMessage())});
            item.add(new Component[]{new Label("remove", "")});
        }
    }

    public void setFocusOnLastItem(boolean focusOnLastItem) {
        this.focusOnLastItem = focusOnLastItem;
    }

    protected EditorPlugin getEditorPlugin() {
        return (EditorPlugin)((Object)this.findParent(EditorPlugin.class));
    }

    protected Component createValueEditor(JcrPropertyValueModel valueModel) throws RepositoryException {
        List factoryList = this.getEditorPlugin().getPluginContext().getServices("service.editor.valuefactory", ValueEditorFactory.class);
        for (ValueEditorFactory factory : factoryList) {
            if (!factory.canEdit(valueModel)) continue;
            return factory.createEditor("value", valueModel);
        }
        if (this.propertyModel.getProperty().getType() == 2) {
            return new BinaryEditor("value", this.propertyModel, this.getEditorPlugin().getPluginContext());
        }
        if (this.propertyModel.getProperty().getDefinition().isProtected()) {
            return new Label("value", (IModel)valueModel){

                public IConverter getConverter(Class type) {
                    if (type.equals(Date.class)) {
                        return PropertyValueEditor.this.dateConverter;
                    }
                    return super.getConverter(type);
                }
            };
        }
        if (this.propertyModel.getProperty().getType() == 6) {
            return new BooleanFieldWidget("value", (IModel)valueModel);
        }
        StringConverter stringModel = new StringConverter(valueModel);
        String asString = stringModel.getObject();
        if (asString.contains("\n")) {
            TextAreaWidget editor = new TextAreaWidget("value", (IModel)stringModel);
            String[] lines = StringUtils.splitByWholeSeparator((String)asString, (String)"\n");
            int rowCount = lines.length;
            int columnCount = 1;
            for (String line : lines) {
                int length = line.length();
                if (length <= columnCount) continue;
                if (length > 100) {
                    columnCount = 100;
                    rowCount += length / 100 + 1;
                    continue;
                }
                columnCount = length;
            }
            editor.setRows(String.valueOf(rowCount + 1));
            return editor;
        }
        if (asString.length() > 100) {
            TextAreaWidget editor = new TextAreaWidget("value", (IModel)stringModel);
            editor.setRows(String.valueOf(asString.length() / 80));
            return editor;
        }
        TextAreaWidget editor = new TextAreaWidget("value", (IModel)stringModel);
        editor.setRows("1");
        return editor;
    }

    private static class ISO8601DateConverter
    extends DateConverter {
        private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSZ");

        private ISO8601DateConverter() {
        }

        public DateFormat getDateFormat(Locale locale) {
            return this.dateFormat;
        }
    }
}

