/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.io.IClusterable;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.Plugin;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.editor.PasswordHashEditor;
import org.hippoecm.frontend.plugins.console.editor.ValueEditorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordHashEditorPlugin
extends Plugin
implements ValueEditorFactory {
    private static final Logger log = LoggerFactory.getLogger(PasswordHashEditorPlugin.class);
    private final int passwordLength;

    public PasswordHashEditorPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        context.registerService((IClusterable)this, "service.editor.valuefactory");
        this.passwordLength = config.getAsInteger("passwordLength", 12);
    }

    @Override
    public boolean canEdit(JcrPropertyValueModel valueModel) {
        if (valueModel == null) {
            return false;
        }
        try {
            Property property = valueModel.getJcrPropertymodel().getProperty();
            return property != null && property.getName().equals("hipposys:password");
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public Component createEditor(String id, JcrPropertyValueModel valueModel) {
        return new PasswordHashEditor(id, this.passwordLength, valueModel.getJcrPropertymodel(), (IModel<String>)valueModel);
    }
}

