/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.io.IClusterable;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.Plugin;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.editor.HstReferenceEditor;
import org.hippoecm.frontend.plugins.console.editor.NodeEditor;
import org.hippoecm.frontend.plugins.console.editor.ValueEditorFactory;

public class HstReferenceEditorPlugin
extends Plugin
implements ValueEditorFactory {
    private static List<String> referenceProperties = new ArrayList<String>(3);

    public HstReferenceEditorPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        context.registerService((IClusterable)this, "service.editor.valuefactory");
    }

    @Override
    public boolean canEdit(JcrPropertyValueModel valueModel) {
        if (valueModel == null) {
            return false;
        }
        try {
            Property property = valueModel.getJcrPropertymodel().getProperty();
            return referenceProperties.contains(property.getName());
        }
        catch (RepositoryException e) {
            NodeEditor.log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public Component createEditor(String id, JcrPropertyValueModel valueModel) {
        return new HstReferenceEditor(id, valueModel.getJcrPropertymodel(), (IModel<String>)valueModel);
    }

    static {
        referenceProperties.add("hst:template");
        referenceProperties.add("hst:componentconfigurationid");
        referenceProperties.add("hst:referencecomponent");
    }
}

