/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.plugins.console.editor.EditorPlugin;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.TextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HstReferenceEditor
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(HstReferenceEditor.class);
    protected static final String PROPERTY_HST_TEMPLATE = "hst:template";
    protected static final String PROPERTY_HST_COMPONENTCONFIGURATIONID = "hst:componentconfigurationid";
    protected static final String PROPERTY_HST_REFERENCECOMPONENT = "hst:referencecomponent";
    private static final String NODE_HST_CONFIGURATION = "hst:configuration";
    private static final String NODE_HST_WORKSPACE = "hst:workspace";
    private static final String NODE_HST_TEMPLATES = "hst:templates";
    private static final String NODE_HST_CONTAINERCOMPONENTREFERENCE = "hst:containercomponentreference";
    private static final String PROPERY_HST_INHERITSFROM = "hst:inheritsfrom";
    private static final String PROPERTY_HST_RENDERPATH = "hst:renderpath";
    private static final String PROPERTY_HST_SCRIPT = "hst:script";
    private static final String PROPERTY_HST_COMPONENTCLASSNAME = "hst:componentclassname";
    private static final String PROPERTY_HST_XTYPE = "hst:xtype";
    private static final String PATH_PREFIX_WORKSPACE_CONTAINERS = "hst:workspace/hst:containers/";
    private static final String PATH_HST_DEFAULT = "/hst:hst/hst:configurations/hst:default";

    HstReferenceEditor(String id, JcrPropertyModel propertyModel, IModel<String> valueModel) {
        super(id);
        this.setOutputMarkupId(true);
        final ReferenceLink referenceLink = new ReferenceLink("reference-link", propertyModel, valueModel);
        this.add(new Component[]{referenceLink});
        TextFieldWidget editor = new TextFieldWidget("reference-edit", valueModel){

            protected void onUpdate(AjaxRequestTarget target) {
                referenceLink.load();
                target.add(new Component[]{HstReferenceEditor.this});
            }
        };
        editor.setSize("40");
        this.add(new Component[]{editor});
    }

    private static class ReferenceLink
    extends AjaxLink<String> {
        private static final long serialVersionUID = 1L;
        private String linkText;
        private JcrNodeModel linkModel;
        private final JcrPropertyModel propertyModel;

        public ReferenceLink(String id, JcrPropertyModel propertyModel, IModel<String> valueModel) {
            super(id, valueModel);
            this.propertyModel = propertyModel;
            this.load();
            this.add(new Component[]{new Label("reference-link-text", (IModel)new PropertyModel((Object)this, "linkText"))});
            this.add(new Behavior[]{new AttributeAppender("style", (IModel)new AbstractReadOnlyModel<Object>(){

                public Object getObject() {
                    return !this.isValidLink() ? "color:blue" : "";
                }
            }, " ")});
        }

        private void load() {
            this.linkText = null;
            this.linkModel = null;
            String relativeNodePath = (String)this.getModelObject();
            if (StringUtils.isBlank((String)relativeNodePath)) {
                return;
            }
            if (relativeNodePath.startsWith("/")) {
                this.linkText = "The value is not correct: Value may not start with a forward slash.";
            } else {
                try {
                    Node targetNode = this.getHstReferencedNode(relativeNodePath);
                    this.linkModel = new JcrNodeModel(targetNode);
                    this.linkText = targetNode.getPath();
                    String title = this.determineTitle(targetNode);
                    if (StringUtils.isNotBlank((String)title)) {
                        this.add(new Behavior[]{TitleAttribute.set((String)title)});
                    }
                }
                catch (PathNotFoundException e) {
                    this.linkText = "(Reference not found. Might be used in inheriting structure though.)";
                }
                catch (RepositoryException e) {
                    this.linkText = "Repository Exception: " + e.getMessage();
                    log.error("Error loading target node by reference " + (String)this.getModelObject());
                }
            }
        }

        protected boolean isLinkEnabled() {
            return this.isValidLink();
        }

        private boolean isValidLink() {
            return this.linkModel != null;
        }

        public void onClick(AjaxRequestTarget target) {
            if (this.linkModel != null) {
                ((EditorPlugin)((Object)this.findParent(EditorPlugin.class))).setDefaultModel((IModel)this.linkModel);
            }
        }

        protected void onDetach() {
            if (this.linkModel != null) {
                this.linkModel.detach();
            }
            super.onDetach();
        }

        private String determineTitle(Node targetNode) throws RepositoryException {
            switch (this.propertyModel.getProperty().getName()) {
                case "hst:template": {
                    if (targetNode.hasProperty(HstReferenceEditor.PROPERTY_HST_RENDERPATH)) {
                        return targetNode.getProperty(HstReferenceEditor.PROPERTY_HST_RENDERPATH).getString();
                    }
                    if (targetNode.hasProperty(HstReferenceEditor.PROPERTY_HST_SCRIPT)) {
                        return "Template contains script";
                    }
                }
                case "hst:componentconfigurationid": 
                case "hst:referencecomponent": {
                    if (targetNode.hasProperty(HstReferenceEditor.PROPERTY_HST_COMPONENTCLASSNAME)) {
                        return targetNode.getProperty(HstReferenceEditor.PROPERTY_HST_COMPONENTCLASSNAME).getString();
                    }
                    if (!targetNode.hasProperty(HstReferenceEditor.PROPERTY_HST_XTYPE)) break;
                    return targetNode.getProperty(HstReferenceEditor.PROPERTY_HST_XTYPE).getString();
                }
            }
            return null;
        }

        private Node getHstReferencedNode(String relativePath) throws RepositoryException {
            Node hstDefaultConfiguration;
            Node templateNode;
            Node currentHstConfiguration = this.propertyModel.getProperty().getParent();
            Node root = currentHstConfiguration.getSession().getRootNode();
            do {
                if (currentHstConfiguration.getPrimaryNodeType().isNodeType(HstReferenceEditor.NODE_HST_WORKSPACE)) {
                    templateNode = this.getConfigurationNode(currentHstConfiguration, relativePath);
                    if (templateNode == null) continue;
                    return templateNode;
                }
                if (!currentHstConfiguration.getPrimaryNodeType().isNodeType(HstReferenceEditor.NODE_HST_CONFIGURATION)) continue;
                templateNode = this.getConfigurationNode(currentHstConfiguration, relativePath);
                if (templateNode == null) break;
                return templateNode;
            } while (!root.isSame((Item)(currentHstConfiguration = currentHstConfiguration.getParent())));
            if (currentHstConfiguration.hasProperty(HstReferenceEditor.PROPERY_HST_INHERITSFROM)) {
                Value[] inheritFromPaths;
                for (Value inheritsFromPath : inheritFromPaths = currentHstConfiguration.getProperty(HstReferenceEditor.PROPERY_HST_INHERITSFROM).getValues()) {
                    Node inheritedHstConfiguration = currentHstConfiguration.getNode(inheritsFromPath.getString());
                    templateNode = this.getConfigurationNode(inheritedHstConfiguration, relativePath);
                    if (templateNode == null) continue;
                    return templateNode;
                }
            }
            if ((hstDefaultConfiguration = UserSession.get().getJcrSession().getNode(HstReferenceEditor.PATH_HST_DEFAULT)).hasNode(HstReferenceEditor.NODE_HST_TEMPLATES) && (templateNode = this.getConfigurationNode(hstDefaultConfiguration, relativePath)) != null) {
                return templateNode;
            }
            throw new PathNotFoundException();
        }

        private Node getConfigurationNode(Node hstConfiguration, String nodeName) throws RepositoryException {
            StringBuilder relPath = new StringBuilder();
            this.addPathPrefix(relPath);
            relPath.append(nodeName);
            if (hstConfiguration.hasNode(relPath.toString())) {
                return hstConfiguration.getNode(relPath.toString());
            }
            return null;
        }

        private void addPathPrefix(StringBuilder relPath) throws RepositoryException {
            boolean isHstTemplate = this.propertyModel.getProperty().getName().equals(HstReferenceEditor.PROPERTY_HST_TEMPLATE);
            if (isHstTemplate) {
                relPath.append(HstReferenceEditor.NODE_HST_TEMPLATES);
                relPath.append("/");
                return;
            }
            boolean isContainerComponentReference = this.propertyModel.getProperty().getParent().getPrimaryNodeType().isNodeType(HstReferenceEditor.NODE_HST_CONTAINERCOMPONENTREFERENCE);
            if (isContainerComponentReference) {
                relPath.append(HstReferenceEditor.PATH_PREFIX_WORKSPACE_CONTAINERS);
            }
        }
    }
}

