/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.value.BinaryImpl;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryUploadDialog
extends AbstractDialog<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(BinaryUploadDialog.class);
    private final FileUploadField fileUploadField;
    private final Model<String> msgText;
    private final JcrPropertyModel model;

    public BinaryUploadDialog(JcrPropertyModel model) {
        this.model = model;
        this.setMultiPart(true);
        this.setNonAjaxSubmit();
        Component[] componentArray = new Component[1];
        this.fileUploadField = new FileUploadField("fileInput");
        componentArray[0] = this.fileUploadField;
        this.add(componentArray);
        this.msgText = new Model((Serializable)((Object)"Upload new binary file"));
        this.add(new Component[]{new Label("message", this.msgText)});
        this.setOkLabel("Import");
    }

    public IModel<String> getTitle() {
        return new Model((Serializable)((Object)"Update binary property"));
    }

    protected void onOk() {
        FileUpload upload = this.fileUploadField.getFileUpload();
        if (upload != null) {
            this.msgText.setObject((Serializable)((Object)"File uploaded."));
            try {
                InputStream inputStream = upload.getInputStream();
                Property property = this.model.getProperty();
                BinaryImpl binary = new BinaryImpl(inputStream);
                property.setValue((Binary)binary);
            }
            catch (RepositoryException e) {
                log.error("Failed to upload binary", (Throwable)e);
                this.error((Serializable)((Object)"Failed to upload binary"));
            }
            catch (IOException e) {
                log.error("Error creating binary", (Throwable)e);
                this.error((Serializable)((Object)"Error updating binary"));
            }
        }
    }
}

