/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.browser;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.swing.tree.TreeNode;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.tree.IJcrTreeNode;
import org.hippoecm.frontend.plugins.console.icons.IconLabel;
import org.hippoecm.frontend.plugins.console.icons.JcrNodeIcon;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;

public final class NodeIconUtils {
    public static Component createJcrNodeIcon(String id, TreeNode node) {
        IModel nodeModel = ((IJcrTreeNode)node).getNodeModel();
        if (nodeModel == null || nodeModel.getObject() == null) {
            return NodeIconUtils.createUnknownNodeIcon(id);
        }
        Node jcrNode = (Node)nodeModel.getObject();
        Label icon = new Label(id, "");
        icon.add(new Behavior[]{CssClass.append((String)JcrNodeIcon.getIconCssClass(jcrNode))});
        String tooltip = NodeIconUtils.determineNodeTooltip(jcrNode);
        if (StringUtils.isNotBlank((String)tooltip)) {
            icon.add(new Behavior[]{TitleAttribute.append((String)tooltip)});
        }
        return icon;
    }

    private static Component createUnknownNodeIcon(String id) {
        return new IconLabel(id, JcrNodeIcon.FA_UNKNOWN_NODE_CSS_CLASS);
    }

    private static String determineNodeTooltip(Node jcrNode) {
        try {
            if (jcrNode.hasProperty("hippostd:state")) {
                return jcrNode.getProperty("hippostd:state").getString();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return null;
    }
}

