/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.behavior;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnLoadHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.string.StringValue;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.event.IObservable;
import org.hippoecm.frontend.model.event.IObserver;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterHistoryBehavior
extends AbstractDefaultAjaxBehavior
implements IObserver {
    private static final Logger log = LoggerFactory.getLogger(ParameterHistoryBehavior.class);
    private static final JavaScriptResourceReference SCRIPT_RESOURCE_REFERENCE = new JavaScriptResourceReference(ParameterHistoryBehavior.class, "js/parameterhistory/parameterhistory.js");
    private static final String PATH_PARAMETER = "_path";
    private static final String UUID_PARAMETER = "_uuid";
    private IModelReference<Node> reference;
    private transient boolean myUpdate;

    public ParameterHistoryBehavior(IModelReference<Node> reference) {
        this.reference = reference;
        this.setReferenceModelFromRequest();
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SCRIPT_RESOURCE_REFERENCE));
        String attributesAsJson = this.renderAjaxAttributes(component).toString();
        response.render((HeaderItem)OnLoadHeaderItem.forScript((CharSequence)("Hippo.ParameterHistory.init(function(path, uuid) {\n    var call = new Wicket.Ajax.Call(),        attributes = jQuery.extend({}, " + attributesAsJson + ");\n    call.ajax(attributes);\n});")));
    }

    protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
        super.updateAjaxAttributes(attributes);
        List dep = attributes.getDynamicExtraParameters();
        dep.add("return { _path: path };");
        dep.add("return { _uuid: uuid };");
    }

    protected void respond(AjaxRequestTarget target) {
        this.setReferenceModelFromRequest();
    }

    public IObservable getObservable() {
        return this.reference;
    }

    public void onEvent(Iterator events) {
        if (this.myUpdate) {
            return;
        }
        IModel model = this.reference.getModel();
        String path = JcrUtils.getNodePathQuietly(model != null ? (Node)model.getObject() : null);
        if (path != null) {
            this.setPathWithAjax(path, false);
        }
    }

    private void setReferenceModelFromRequest() {
        this.myUpdate = true;
        RequestCycle requestCycle = RequestCycle.get();
        IRequestParameters queryParameters = requestCycle.getRequest().getQueryParameters();
        StringValue path = queryParameters.getParameterValue(PATH_PARAMETER);
        if (!path.isEmpty()) {
            this.setReferenceFromPath(path.toString());
        } else {
            StringValue uuid = queryParameters.getParameterValue(UUID_PARAMETER);
            if (!uuid.isEmpty()) {
                this.setReferenceFromUuid(uuid.toString());
            }
        }
        this.myUpdate = false;
    }

    private void setReferenceFromUuid(String uuid) {
        Session jcrSession = UserSession.get().getJcrSession();
        Node node = null;
        try {
            node = jcrSession.getNodeByIdentifier(uuid);
        }
        catch (RepositoryException e) {
            log.info("Could not find node by uuid: {}", (Object)uuid);
        }
        if (node != null) {
            JcrNodeModel model = new JcrNodeModel(node);
            this.reference.setModel((IModel)model);
            this.setPathWithAjax(model.getItemModel().getPath(), true);
        }
    }

    private void setReferenceFromPath(String path) {
        JcrNodeModel startModel;
        JcrNodeModel model;
        for (model = startModel = new JcrNodeModel(path); model != null && model.getNode() == null; model = model.getParentModel()) {
        }
        if (!startModel.equals((Object)model)) {
            if (model == null) {
                model = new JcrNodeModel("/");
            }
            this.setPathWithAjax(model.getItemModel().getPath(), true);
        }
        this.reference.setModel((IModel)model);
    }

    private void setPathWithAjax(String path, boolean replace) {
        AjaxRequestTarget ajax = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (ajax != null) {
            String script = String.format("Hippo.ParameterHistory.setPath('%s', %s);", path, replace);
            ajax.appendJavaScript((CharSequence)script);
        }
    }
}

