/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.workflow;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.plugins.console.menu.workflow.WorkflowPlugin;
import org.hippoecm.frontend.service.render.RenderService;
import org.hippoecm.repository.api.HippoWorkspace;
import org.hippoecm.repository.api.WorkflowDescriptor;
import org.hippoecm.repository.api.WorkflowManager;

public class WorkflowDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private final RenderService plugin;

    public WorkflowDialog(WorkflowPlugin plugin) {
        this.plugin = plugin;
        IModel nodeModel = plugin.getDefaultModel();
        MultiLineLabel dump = new MultiLineLabel("dump", "");
        dump.setOutputMarkupId(true);
        this.add(new Component[]{dump});
        try {
            Node subject = (Node)nodeModel.getObject();
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(ostream);
            Session session = subject.getSession();
            WorkflowManager workflowManager = ((HippoWorkspace)session.getWorkspace()).getWorkflowManager();
            Node categories = session.getRootNode().getNode("hippo:configuration/hippo:workflows");
            NodeIterator iter = categories.getNodes();
            while (iter.hasNext()) {
                Node category = iter.nextNode();
                WorkflowDescriptor descriptor = workflowManager.getWorkflowDescriptor(category.getName(), subject);
                out.println("Category " + category.getName() + ": " + (descriptor != null ? descriptor.getDisplayName() : "none"));
            }
            out.flush();
            dump.setDefaultModel((IModel)new Model((Serializable)((Object)new String(ostream.toByteArray()))));
        }
        catch (RepositoryException ex) {
            dump.setDefaultModel((IModel)new Model((Serializable)((Object)(((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage()))));
        }
        this.setOkVisible(false);
        this.setFocusOnOk();
    }

    public void onOk() {
    }

    public void onCancel() {
    }

    public IModel<String> getTitle() {
        String path;
        IModel nodeModel = this.plugin.getDefaultModel();
        try {
            path = ((Node)nodeModel.getObject()).getPath();
        }
        catch (RepositoryException e) {
            path = e.getMessage();
        }
        return new Model((Serializable)((Object)("Workflow for " + path)));
    }
}

