/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.save;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.PluginRequestTarget;
import org.hippoecm.frontend.dialog.DialogLink;
import org.hippoecm.frontend.dialog.IDialogFactory;
import org.hippoecm.frontend.dialog.IDialogService;
import org.hippoecm.frontend.plugins.console.Shortcuts;
import org.hippoecm.frontend.session.UserSession;

public class SaveDialogLink
extends DialogLink {
    private static final long serialVersionUID = 1L;

    public SaveDialogLink(String id, IModel<String> linkText, IDialogFactory dialogFactory, IDialogService dialogService) {
        super(id, linkText, dialogFactory, dialogService, Shortcuts.CTRL_S);
        Label label = new Label("dialog-link-text-extended", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                if (SaveDialogLink.this.hasSessionChanges()) {
                    return "*";
                }
                return "";
            }
        });
        label.setOutputMarkupId(true);
        this.link.add(new Component[]{label});
    }

    private boolean hasSessionChanges() {
        Session session = UserSession.get().getJcrSession();
        try {
            return session.hasPendingChanges();
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        tag.put("class", (CharSequence)this.getCssClass());
    }

    private String getCssClass() {
        return this.hasSessionChanges() ? "hippo-console-menu-actions-save session-changes" : "hippo-console-menu-actions-save";
    }

    public void update(PluginRequestTarget target) {
        target.add(new Component[]{this.link.get("dialog-link-text-extended")});
        target.appendJavaScript((CharSequence)("Wicket.$('" + this.getMarkupId() + "').setAttribute('class', '" + this.getCssClass() + "');"));
    }
}

