/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.recompute;

import java.io.Serializable;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.plugins.console.menu.recompute.RecomputeVisitor;
import org.hippoecm.frontend.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecomputeDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RecomputeDialog.class);
    private boolean automaticSave = true;

    public RecomputeDialog(IModel<Node> model) {
        super(model);
        String path = null;
        try {
            path = ((Node)this.getModelObject()).getPath();
        }
        catch (RepositoryException e) {
            log.error(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
        }
        this.add(new Component[]{new CheckBox("automatic-save", (IModel)new PropertyModel((Object)this, "automaticSave"))});
        String message = "The derived data properties of node " + path + " and its subnodes will be recalculated. This might for instance be needed after moving a folder or a document. Do you want to continue?";
        this.add(new Component[]{new Label("message", (IModel)new Model((Serializable)((Object)message)))});
        this.setFocusOnOk();
    }

    public void onOk() {
        try {
            ((Node)this.getModelObject()).accept((ItemVisitor)new RecomputeVisitor(this.automaticSave));
            if (this.automaticSave) {
                UserSession.get().getJcrSession().save();
            }
        }
        catch (RepositoryException e) {
            log.error("Error during fixing hippo:paths properties", (Throwable)e);
        }
    }

    public IModel<String> getTitle() {
        return new Model((Serializable)((Object)"Recalculate derived data"));
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }
}

