/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.permissions;

import java.io.Serializable;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.plugins.console.menu.permissions.PermissionsPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionsDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    public static final String READ_ACTION = "read";
    public static final String REMOVE_ACTION = "remove";
    public static final String ADD_NODE_ACTION = "add_node";
    public static final String SET_PROPERTY_ACTION = "set_property";
    public static final String[] JCR_ACTIONS = new String[]{"read", "remove", "add_node", "set_property"};
    public static final String READ_PRIVILEGE = "jcr:read";
    public static final String WRITE_PRIVILEGE = "jcr:write";
    public static final String ALL_PRIVILEGE = "jcr:all";
    public static final String SET_PROPERTIES_PRIVILEGE = "jcr:setProperties";
    public static final String ADD_CHILD_PRIVILEGE = "jcr:addChildNodes";
    public static final String REMOVE_CHILD_PRIVILEGE = "jcr:removeChildNodes";
    public static final String AUTHOR_PRIVILEGE = "hippo:author";
    public static final String EDITOR_PRIVILEGE = "hippo:editor";
    public static final String ADMIN_PRIVILEGE = "hippo:admin";
    public static final String[] JCR_PRIVILEGES = new String[]{"jcr:read", "jcr:write", "jcr:all", "jcr:setProperties", "jcr:addChildNodes", "jcr:removeChildNodes", "hippo:author", "hippo:editor", "hippo:admin"};
    static final Logger log = LoggerFactory.getLogger(PermissionsDialog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionsDialog(PermissionsPlugin plugin) {
        IModel nodeModel = plugin.getDefaultModel();
        this.setModel(nodeModel);
        Label usernameLabel = new Label("username", "Unknown");
        Label membershipsLabel = new Label("memberships", "None");
        Label allActionsLabel = new Label("all-actions", "None");
        Label allPrivilegesLabel = new Label("all-privileges", "None");
        Label actionsLabel = new Label("actions", "None");
        Label privilegesLabel = new Label("privileges", "None");
        this.add(new Component[]{usernameLabel});
        this.add(new Component[]{membershipsLabel});
        this.add(new Component[]{allActionsLabel});
        this.add(new Component[]{allPrivilegesLabel});
        this.add(new Component[]{actionsLabel});
        this.add(new Component[]{privilegesLabel});
        Session privSession = null;
        try {
            Node subject = (Node)nodeModel.getObject();
            privSession = subject.getSession().impersonate((Credentials)new SimpleCredentials("workflowuser", new char[0]));
            String userID = subject.getSession().getUserID();
            Object[] memberships = this.getMemberships(privSession, userID);
            Object[] actions = this.getAllowedActions(subject, JCR_ACTIONS);
            Object[] roles = this.getAllowedActions(subject, JCR_PRIVILEGES);
            usernameLabel.setDefaultModel((IModel)new Model((Serializable)((Object)userID)));
            membershipsLabel.setDefaultModel((IModel)new Model((Serializable)((Object)StringUtils.join((Object[])memberships, (String)", "))));
            allActionsLabel.setDefaultModel((IModel)new Model((Serializable)((Object)StringUtils.join((Object[])JCR_ACTIONS, (String)", "))));
            allPrivilegesLabel.setDefaultModel((IModel)new Model((Serializable)((Object)StringUtils.join((Object[])JCR_PRIVILEGES, (String)", "))));
            actionsLabel.setDefaultModel((IModel)new Model((Serializable)((Object)StringUtils.join((Object[])actions, (String)", "))));
            privilegesLabel.setDefaultModel((IModel)new Model((Serializable)((Object)StringUtils.join((Object[])roles, (String)", "))));
        }
        catch (RepositoryException ex) {
            actionsLabel.setDefaultModel((IModel)new Model((Serializable)((Object)(((Object)((Object)ex)).getClass().getName() + ": " + ex.getMessage()))));
        }
        finally {
            if (privSession != null) {
                privSession.logout();
            }
        }
        this.setOkVisible(false);
        this.setFocusOnOk();
    }

    private boolean hasPermission(Node node, String actions) throws RepositoryException {
        try {
            node.getSession().checkPermission(node.getPath(), actions);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    private String[] getAllowedActions(Node node, String[] actions) throws RepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        for (String action : actions) {
            if (!this.hasPermission(node, action)) continue;
            list.add(action);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private String[] getMemberships(Session session, String username) throws RepositoryException {
        String queryString = "//element(*, hipposys:group)[jcr:contains(@hipposysedit:members, '" + username + "')]";
        String queryType = "xpath";
        ArrayList<String> list = new ArrayList<String>();
        try {
            Query query = session.getWorkspace().getQueryManager().createQuery(queryString, "xpath");
            NodeIterator nodeIter = query.execute().getNodes();
            log.debug("Number of memberships found with query '{}' : {}", (Object)queryString, (Object)nodeIter.getSize());
            while (nodeIter.hasNext()) {
                Node node = nodeIter.nextNode();
                if (node == null) continue;
                list.add(node.getName());
            }
        }
        catch (RepositoryException e) {
            log.error("Error executing query[" + queryString + "]", (Throwable)e);
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    public void onOk() {
    }

    public void onCancel() {
    }

    public IModel getTitle() {
        String path;
        IModel nodeModel = this.getModel();
        try {
            path = ((Node)nodeModel.getObject()).getPath();
        }
        catch (RepositoryException e) {
            path = e.getMessage();
            log.warn("Unable to get path for : " + nodeModel);
        }
        return new Model((Serializable)((Object)("Permissions for " + path)));
    }
}

