/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.open;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.DefaultCssAutoCompleteTextField;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugins.console.NodeModelReference;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.HippoNode;
import org.hippoecm.repository.api.StringCodecFactory;

public class OpenDialog
extends AbstractDialog<Node> {
    private final String WICKET_ELEMENT_ID = "pathOrId";
    private static final long serialVersionUID = 1L;
    private String pathOrId;
    private NodeModelReference modelReference;

    public OpenDialog(NodeModelReference modelReference) {
        this.modelReference = modelReference;
        Model labelModel = new Model((Serializable)((Object)"Path or UUID"));
        this.add(new Component[]{new Label("label", (IModel)labelModel)});
        this.add(new Component[]{this.setFocus((Component)this.makeValueField(this.getValueCurrentlySelectedJcrNode()))});
    }

    private AutoCompleteTextField<String> makeValueField(PropertyModel<String> value) {
        return new AutoCompleteTextField<String>("pathOrId", value, this.getAutoCompleteSettings()){
            private static final long serialVersionUID = 1L;

            protected Iterator<String> getChoices(String input) {
                TreeSet result = new TreeSet();
                OpenDialog.this.addMatchingNodes(input, result);
                return result.iterator();
            }

            public void renderHead(IHeaderResponse response) {
                super.renderHead(response);
                String script = "document.getElementById('" + this.getMarkupId() + "').focus(); document.getElementById('" + this.getMarkupId() + "').select();";
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)script));
                response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(DefaultCssAutoCompleteTextField.class, "DefaultCssAutoCompleteTextField.css")));
            }
        };
    }

    private PropertyModel<String> getValueCurrentlySelectedJcrNode() {
        PropertyModel value = new PropertyModel((Object)this, "pathOrId");
        Node node = (Node)this.modelReference.getModel().getObject();
        try {
            value.setObject((Object)node.getPath());
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return value;
    }

    private AutoCompleteSettings getAutoCompleteSettings() {
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setAdjustInputWidth(false).setUseSmartPositioning(true).setShowCompleteListOnFocusGain(true).setShowListOnEmptyInput(true);
        return settings;
    }

    private void addMatchingNodes(String path, Collection<String> result) {
        String relPath = path.substring(1);
        try {
            NodeIterator nodes = this.getNodesFromRelativePath(relPath);
            while (nodes.hasNext()) {
                result.add(nodes.nextNode().getPath());
            }
        }
        catch (PathNotFoundException e) {
            this.addNodesMatchingOnSubstring(relPath, result);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private NodeIterator getNodesFromRelativePath(String relPath) throws RepositoryException {
        HippoNode node = UserSession.get().getRootNode();
        if (!relPath.isEmpty()) {
            Node nodeAtPath = this.getNodeIgnoreException((Node)node, relPath = this.removeDoubleSlashes(relPath));
            if (nodeAtPath != null) {
                node = nodeAtPath;
            } else {
                String encRelPath = StringCodecFactory.ISO9075Helper.encodeLocalName((String)relPath);
                nodeAtPath = this.getNodeIgnoreException((Node)node, encRelPath);
                if (nodeAtPath != null) {
                    node = nodeAtPath;
                } else {
                    throw new PathNotFoundException("Couldn't find node with relative path: " + relPath);
                }
            }
        }
        return node.getNodes();
    }

    private String removeDoubleSlashes(String path) {
        while (path.contains("//")) {
            path = path.replace("//", "/");
        }
        return path;
    }

    private Node getNodeIgnoreException(Node node, String path) {
        try {
            return node.getNode(path);
        }
        catch (RepositoryException repositoryException) {
            return null;
        }
    }

    private void addNodesMatchingOnSubstring(String relPath, Collection<String> result) {
        String subPath = relPath.substring(0, relPath.lastIndexOf(47) + 1);
        String remainingQuery = relPath.substring(subPath.length());
        try {
            NodeIterator nodes = this.getNodesFromRelativePath(subPath);
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (!node.getName().startsWith(remainingQuery)) continue;
                result.add(node.getPath());
            }
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    protected void onOk() {
        this.pathOrId = this.pathOrId.trim();
        Session jcrSession = UserSession.get().getJcrSession();
        Node selected = null;
        try {
            if (this.pathOrId.startsWith("/")) {
                if (jcrSession.nodeExists(this.pathOrId)) {
                    selected = jcrSession.getNode(this.pathOrId);
                }
            } else {
                Node parentNode = (Node)this.modelReference.getModel().getObject();
                selected = parentNode.hasNode(this.pathOrId) ? parentNode.getNode(this.pathOrId) : jcrSession.getNodeByIdentifier(this.pathOrId);
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (selected == null) {
            this.error((Serializable)((Object)"Node was not found, please try again."));
        } else {
            this.modelReference.setModel((IModel)new JcrNodeModel(selected));
        }
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Open node by path or UUID"));
    }

    public IValueMap getProperties() {
        return new ValueMap("width=640,height=200").makeImmutable();
    }
}

