/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.nodereset;

import java.io.IOException;
import java.io.Serializable;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.ReferenceWorkspace;
import org.hippoecm.repository.util.JcrUtils;

public class NodeResetDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final String[] ILLEGAL_PATHS = new String[]{"/hippo:log", "/formdata", "/jcr:system"};
    private String path;

    public NodeResetDialog(IModel<Node> model) {
        super(model);
        this.add(new Component[]{new Label("message", "Resetting a node means that you undo all changes that were made to it since the system was bootstrapped. Changes will not be automatically saved so you can inspect the result of resetting first.")});
        try {
            if (UserSession.get().getHippoRepository().getOrCreateReferenceWorkspace() == null) {
                this.error((Serializable)((Object)"This functionality is not available in your environment"));
                this.setOkEnabled(false);
                return;
            }
            Node node = (Node)this.getModelObject();
            this.path = node.getPath();
            if (!this.isValidPath(this.path)) {
                this.error((Serializable)((Object)"Reset in this context is not supported"));
                this.setOkEnabled(false);
                return;
            }
            if (this.isSameNameSibling(node)) {
                this.error((Serializable)((Object)"Resetting same name siblings is not supported"));
                this.setOkEnabled(false);
            }
        }
        catch (RepositoryException e) {
            this.error((Serializable)((Object)("An unexpected error occurred: " + e.getMessage())));
            this.setOkEnabled(false);
        }
    }

    private boolean isValidPath(String path) {
        if (path.equals("/")) {
            return false;
        }
        if (path.equals("/hippo:configuration")) {
            return false;
        }
        if (path.equals("/hippo:namespaces")) {
            return false;
        }
        for (String illegalPath : ILLEGAL_PATHS) {
            if (!path.startsWith(illegalPath)) continue;
            return false;
        }
        return true;
    }

    protected void onOk() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        Session session = null;
        try {
            ReferenceWorkspace referenceWorkspace = UserSession.get().getHippoRepository().getOrCreateReferenceWorkspace();
            session = referenceWorkspace.login();
            if (!session.nodeExists("/hippo:configuration")) {
                referenceWorkspace.bootstrap();
            }
            if (!session.nodeExists(this.path)) {
                this.error((Serializable)((Object)("No node at " + this.path + " in reference repository")));
                return;
            }
            Node reference = session.getNode(this.path);
            Node parent = ((Node)this.getModelObject()).getParent();
            ((Node)this.getModelObject()).remove();
            JcrUtils.copy((Node)reference, (String)reference.getName(), (Node)parent);
            if (parent.getPrimaryNodeType().hasOrderableChildNodes()) {
                this.order(reference, parent);
            }
        }
        catch (RepositoryException e) {
            this.error((Serializable)((Object)("An unexpected error occurred: " + e.getMessage())));
            try {
                session.refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            this.error((Serializable)((Object)("An unexpected error occurred: " + e.getMessage())));
            try {
                session.refresh(false);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void order(Node reference, Node parent) throws RepositoryException {
        String srcChildRelPath = reference.getName();
        String destChildRelPath = null;
        NodeIterator siblings = reference.getParent().getNodes();
        while (siblings.hasNext()) {
            if (!siblings.nextNode().isSame((Item)reference) || !siblings.hasNext()) continue;
            destChildRelPath = siblings.nextNode().getName();
        }
        if (destChildRelPath != null && parent.hasNode(destChildRelPath)) {
            parent.orderBefore(srcChildRelPath, destChildRelPath);
        }
    }

    private boolean isSameNameSibling(Node node) throws RepositoryException {
        return node.getParent().getNodes(node.getName()).getSize() > 1L;
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)("Reset " + this.path)));
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }
}

