/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.lock;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockManager;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.ReadOnlyModel;
import org.hippoecm.frontend.model.SerializableSupplier;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.hippoecm.frontend.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnlockPlugin
extends RenderPlugin<Node> {
    private static final Logger log = LoggerFactory.getLogger(UnlockPlugin.class);
    private final AjaxLink<Void> link;

    public UnlockPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        Label label = new Label("link-text", (IModel)ReadOnlyModel.of((SerializableSupplier & Serializable)() -> {
            if (this.isLockable()) {
                return this.isLocked() ? "Unlock" : "Not locked";
            }
            return "Lock/Unlock";
        }));
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{CssClass.append((IModel)ReadOnlyModel.of((SerializableSupplier & Serializable)() -> {
            if (this.isLockable()) {
                return this.isLocked() ? "dropdown-link-green" : "dropdown-link-red";
            }
            return "dropdown-link-disabled";
        }))});
        this.link = new AjaxLink<Void>("link"){

            public void onClick(AjaxRequestTarget target) {
                UnlockPlugin.this.unlock();
            }
        };
        this.link.add(new Component[]{label});
        this.link.setEnabled(this.isLockable());
        this.add(new Component[]{this.link});
    }

    private boolean isLocked() {
        try {
            Node node = (Node)this.getModelObject();
            return node != null && node.isLocked();
        }
        catch (RepositoryException e) {
            log.error("An error occurred determining if node is locked.", (Throwable)e);
            return false;
        }
    }

    private boolean isLockable() {
        try {
            Node node = (Node)this.getModelObject();
            return node != null && node.isNodeType("mix:lockable");
        }
        catch (RepositoryException e) {
            log.error("An error occurred determining if node is lockable.", (Throwable)e);
            return false;
        }
    }

    private void unlock() {
        try {
            LockManager lockManager = UserSession.get().getJcrSession().getWorkspace().getLockManager();
            lockManager.unlock(((Node)this.getModelObject()).getPath());
        }
        catch (RepositoryException e) {
            log.error("An error occurred trying to unlock node.", (Throwable)e);
        }
    }

    protected void onModelChanged() {
        this.link.setEnabled(this.isLocked());
        if (!this.isLockable()) {
            this.add(new Behavior[]{TitleAttribute.set((String)"Only lockable nodes can be locked or unlocked.")});
        } else {
            this.add(new Behavior[]{TitleAttribute.clear()});
        }
        this.redraw();
    }
}

