/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.delete;

import java.io.Serializable;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DeleteDialog.class);
    private final IModelReference modelReference;
    private boolean immediateSave;

    public DeleteDialog(IModelReference<Node> modelReference) {
        String path;
        this.modelReference = modelReference;
        IModel model = modelReference.getModel();
        this.setModel(model);
        try {
            Node node = (Node)model.getObject();
            if (node != null) {
                path = node.getPath();
            } else {
                path = "No node selected";
                this.setOkEnabled(false);
            }
        }
        catch (RepositoryException e) {
            path = e.getMessage();
        }
        this.add(new Component[]{new Label("message", (IModel)new StringResourceModel("delete.message", (Component)this, null, null, new Object[]{path}))});
        this.add(new Component[]{new CheckBox("immediateSave", (IModel)new PropertyModel((Object)this, "immediateSave"))});
        this.setFocusOnOk();
    }

    public void onOk() {
        try {
            Node node = (Node)this.getModel().getObject();
            Node siblingOrParent = this.getSiblingOrParent(node);
            node.remove();
            if (this.immediateSave) {
                node.getSession().save();
            }
            this.modelReference.setModel((IModel)new JcrNodeModel(siblingOrParent));
        }
        catch (RepositoryException ex) {
            log.error("Error while deleting document", (Throwable)ex);
            this.error((Serializable)((Object)("Error while deleting document " + ex.getMessage())));
        }
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)this.getString("dialog.title")));
    }

    public IValueMap getProperties() {
        return DialogConstants.SMALL;
    }

    private Node getSiblingOrParent(Node node) throws RepositoryException {
        Node parent = node.getParent();
        NodeIterator nodes = parent.getNodes();
        Node sibling = null;
        while (nodes.hasNext()) {
            Node nextNode = nodes.nextNode();
            if (node.isSame((Item)nextNode)) {
                if (nodes.hasNext()) {
                    return nodes.nextNode();
                }
                if (sibling != null) {
                    return sibling;
                }
            }
            sibling = nextNode;
        }
        return parent;
    }
}

