/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.download.DownloadLink;
import org.hippoecm.repository.api.HippoSession;
import org.hippoecm.repository.api.NodeNameCodec;

public class DownloadExportAsPackageLink
extends DownloadLink<Node> {
    private static final long serialVersionUID = 1L;
    private File file;

    public DownloadExportAsPackageLink(String id, IModel<Node> model) {
        super(id, model);
    }

    protected String getFilename() {
        try {
            return NodeNameCodec.decode((String)((Node)this.getModel().getObject()).getName()) + ".zip";
        }
        catch (RepositoryException e) {
            this.error((Serializable)((Object)"Unable to get node name for file name, using default"));
            return null;
        }
    }

    protected void onDownloadTargetDetach() {
        if (this.file != null) {
            FileUtils.deleteQuietly((File)this.file);
        }
    }

    protected InputStream getContent() {
        HippoSession session = (HippoSession)UserSession.get().getJcrSession();
        try {
            this.file = session.exportEnhancedSystemViewPackage(((Node)this.getModelObject()).getPath(), true);
            return new FileInputStream(this.file);
        }
        catch (RepositoryException e) {
            this.error((Serializable)((Object)("Repository exception during export: " + e.getMessage())));
        }
        catch (IOException e) {
            this.error((Serializable)((Object)("IOException during export: " + e.getMessage())));
        }
        return null;
    }
}

