/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.content;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.time.Time;
import org.hippoecm.frontend.widgets.download.DownloadLink;
import org.hippoecm.repository.api.HippoSession;
import org.hippoecm.repository.api.NodeNameCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadExportAsFileLink
extends DownloadLink<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DownloadExportAsFileLink.class);
    private IModel<Boolean> skipBinaryModel;
    private File tempFile;

    public DownloadExportAsFileLink(String id, IModel<Node> model, IModel<Boolean> skipBinaryModel) {
        super(id, model);
        this.skipBinaryModel = skipBinaryModel;
    }

    protected String getFilename() {
        try {
            return NodeNameCodec.decode((String)((Node)this.getModel().getObject()).getName()) + ".xml";
        }
        catch (RepositoryException e) {
            String message = "Unable to get node name for file name, using default";
            log.error("Unable to get node name for file name, using default", (Throwable)e);
            this.error((Serializable)((Object)"Unable to get node name for file name, using default"));
            return null;
        }
    }

    protected void onDownloadTargetDetach() {
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getContent() {
        try {
            this.tempFile = File.createTempFile("export-" + Time.now().toString() + "-", ".xml");
            try (FileOutputStream fos = new FileOutputStream(this.tempFile);
                 BufferedOutputStream bos = new BufferedOutputStream(fos);){
                boolean skipBinary = (Boolean)this.skipBinaryModel.getObject();
                ((HippoSession)((Node)this.getModelObject()).getSession()).exportDereferencedView(((Node)this.getModelObject()).getPath(), (OutputStream)bos, skipBinary, false);
            }
            return new FileInputStream(this.tempFile);
        }
        catch (FileNotFoundException e) {
            String message = "Tempfile missing during export";
            this.error((Serializable)((Object)"Tempfile missing during export"));
            log.error("Tempfile missing during export", (Throwable)e);
        }
        catch (IOException e) {
            String message = "IOException during export";
            this.error((Serializable)((Object)"IOException during export"));
            log.error("IOException during export", (Throwable)e);
        }
        catch (RepositoryException e) {
            String message = "Repository exception during export: " + e.getMessage();
            this.error((Serializable)((Object)message));
            log.error(message, (Throwable)e);
        }
        return null;
    }
}

