/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.content;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugins.console.menu.content.DownloadExportAsFileLink;
import org.hippoecm.frontend.plugins.console.menu.content.DownloadExportAsPackageLink;
import org.hippoecm.repository.api.HippoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ContentExportDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContentExportDialog.class);
    private boolean skipBinary = false;
    private static IValueMap SIZE = new ValueMap("width=855,height=475").makeImmutable();

    public ContentExportDialog(final IModelReference<Node> modelReference) {
        final IModel nodeModel = modelReference.getModel();
        this.setModel(nodeModel);
        try {
            String path = ((Node)nodeModel.getObject()).getPath();
            this.add(new Component[]{new Label("message", (IModel)new StringResourceModel("dialog.message", (Component)this, null, null, new Object[]{path}))});
        }
        catch (RepositoryException e) {
            log.error("Error getting node from model for content export", (Throwable)e);
            throw new RuntimeException("Error getting node from model for content export: " + e.getMessage());
        }
        PropertyModel skipBinaryModel = new PropertyModel((Object)this, "skipBinary");
        AjaxCheckBox skipBinaries = new AjaxCheckBox("skip-binaries", (IModel)skipBinaryModel){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        };
        this.add(new Component[]{skipBinaries});
        DownloadExportAsPackageLink downloadPackageLink = new DownloadExportAsPackageLink("download-zip-link", (IModel<Node>)modelReference.getModel());
        this.add(new Component[]{downloadPackageLink});
        DownloadExportAsFileLink downloadFileLink = new DownloadExportAsFileLink("download-xml-link", (IModel<Node>)nodeModel, (IModel<Boolean>)skipBinaryModel);
        this.add(new Component[]{downloadFileLink});
        final Label dump = new Label("dump");
        dump.setOutputMarkupId(true);
        this.add(new Component[]{dump});
        AjaxLink<String> viewLink = new AjaxLink<String>("view-link"){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                String export;
                try {
                    Node node = (Node)nodeModel.getObject();
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    ((HippoSession)node.getSession()).exportDereferencedView(node.getPath(), (OutputStream)out, ContentExportDialog.this.skipBinary, false);
                    export = ContentExportDialog.this.prettyPrint(out.toByteArray());
                    JcrNodeModel newNodeModel = new JcrNodeModel(node);
                    modelReference.setModel((IModel)newNodeModel);
                }
                catch (Exception e) {
                    export = e.getMessage();
                }
                dump.setDefaultModel((IModel)new Model((Serializable)((Object)export)));
                target.add(new Component[]{dump});
            }
        };
        this.add(new Component[]{viewLink});
        this.setOkVisible(false);
    }

    public IModel<String> getTitle() {
        String path;
        IModel nodeModel = this.getModel();
        try {
            path = ((Node)nodeModel.getObject()).getPath();
        }
        catch (RepositoryException e) {
            path = e.getMessage();
        }
        return new Model((Serializable)((Object)("XML Export " + path)));
    }

    public boolean isSkipBinary() {
        return this.skipBinary;
    }

    public void setSkipBinary(boolean skipBinary) {
        this.skipBinary = skipBinary;
    }

    public IValueMap getProperties() {
        return SIZE;
    }

    private String prettyPrint(byte[] bytes) throws Exception {
        StreamSource source = new StreamSource(new ByteArrayInputStream(bytes));
        DOMResult result = new DOMResult();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer identityTransformer = transformerFactory.newTransformer();
        identityTransformer.transform(source, result);
        Document doc = (Document)result.getNode();
        OutputFormat format = new OutputFormat(doc);
        format.setEncoding("UTF-8");
        format.setIndenting(true);
        format.setIndent(2);
        format.setLineWidth(80);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLSerializer xmlSerializer = new XMLSerializer((OutputStream)out, format);
        xmlSerializer.serialize(doc);
        return out.toString("UTF-8");
    }
}

