/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.cnd;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.session.UserSession;
import org.onehippo.repository.bootstrap.InitializationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CndImportDialog
extends AbstractDialog<Void> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CndImportDialog.class);
    private final FileUploadField fileUploadField;
    private final Model<String> msgText;

    public CndImportDialog() {
        this.setMultiPart(true);
        this.setNonAjaxSubmit();
        Component[] componentArray = new Component[1];
        this.fileUploadField = new FileUploadField("fileInput");
        componentArray[0] = this.fileUploadField;
        this.add(componentArray);
        this.msgText = new Model((Serializable)((Object)"Import a CND file."));
        this.add(new Component[]{new Label("message", this.msgText)});
        this.setOkLabel("import");
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Import node type definition file"));
    }

    protected void onOk() {
        FileUpload upload = this.fileUploadField.getFileUpload();
        if (upload != null) {
            this.msgText.setObject((Serializable)((Object)"File uploaded."));
            try {
                Session session = UserSession.get().getJcrSession();
                InitializationProcessor initializationProcessor = UserSession.get().getHippoRepository().getInitializationProcessor();
                if (initializationProcessor == null) {
                    this.error((Serializable)((Object)"This functionality is not available in your environment"));
                    return;
                }
                Node initializeFolder = session.getNode("/hippo:configuration/hippo:initialize");
                if (initializeFolder.hasNode("console-import-cnd")) {
                    initializeFolder.getNode("console-import-cnd").remove();
                }
                Node initializeItem = initializeFolder.addNode("console-import-cnd", "hipposys:initializeitem");
                try {
                    initializeItem.setProperty("hippo:nodetypes", session.getValueFactory().createBinary(upload.getInputStream()));
                    initializeItem.setProperty("hippo:status", "pending");
                    session.save();
                    initializationProcessor.processInitializeItems(session, Arrays.asList(initializeItem));
                    session.save();
                }
                catch (IOException e) {
                    log.error("Failed to read upload file for importing cnd", (Throwable)e);
                    this.error((Serializable)((Object)"Failed to read upload file"));
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to import cnd", (Throwable)e);
                this.error((Serializable)((Object)"Failed to import cnd"));
            }
        }
    }
}

