/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.check;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.ReadOnlyModel;
import org.hippoecm.frontend.model.SerializableSupplier;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckInOutPlugin
extends RenderPlugin<Node> {
    private static final Logger log = LoggerFactory.getLogger(CheckInOutPlugin.class);
    private final AjaxLink<Void> link;

    public CheckInOutPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        final Label label = new Label("link-text", (IModel)ReadOnlyModel.of((SerializableSupplier & Serializable)() -> {
            if (this.isVersionable()) {
                return this.isCheckedOut() ? "Check In" : "Check Out";
            }
            return "Check In/Out";
        }));
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{CssClass.append((IModel)ReadOnlyModel.of((SerializableSupplier & Serializable)() -> {
            if (this.isVersionable()) {
                return this.isCheckedOut() ? "dropdown-link-green" : "dropdown-link-red";
            }
            return "dropdown-link-disabled";
        }))});
        this.link = new AjaxLink<Void>("link"){

            public void onClick(AjaxRequestTarget target) {
                if (CheckInOutPlugin.this.isVersionable()) {
                    if (CheckInOutPlugin.this.isCheckedOut()) {
                        CheckInOutPlugin.this.checkin();
                    } else {
                        CheckInOutPlugin.this.checkout();
                    }
                }
                target.add(new Component[]{label});
            }
        };
        this.link.add(new Component[]{label});
        this.link.setEnabled(this.isVersionable());
        this.add(new Component[]{this.link});
    }

    private boolean isCheckedOut() {
        try {
            Node node = (Node)this.getModelObject();
            return node != null && node.isCheckedOut();
        }
        catch (RepositoryException e) {
            log.error("An error occurred determining if node is checked out.", (Throwable)e);
            return false;
        }
    }

    private boolean isVersionable() {
        try {
            Node node = (Node)this.getModelObject();
            return node != null && node.isNodeType("mix:versionable");
        }
        catch (RepositoryException e) {
            log.error("An error occurred determining if node is versionable.", (Throwable)e);
            return false;
        }
    }

    private void checkin() {
        try {
            this.getSession().getJcrSession().getWorkspace().getVersionManager().checkin(((Node)this.getModelObject()).getPath());
        }
        catch (RepositoryException e) {
            log.error("An error occurred trying to check in node.", (Throwable)e);
        }
    }

    private void checkout() {
        try {
            this.getSession().getJcrSession().getWorkspace().getVersionManager().checkout(((Node)this.getModelObject()).getPath());
        }
        catch (RepositoryException e) {
            log.error("An error occurred trying to check out node.", (Throwable)e);
        }
    }

    protected void onModelChanged() {
        this.link.setEnabled(this.isVersionable());
        if (!this.isVersionable()) {
            this.add(new Behavior[]{TitleAttribute.set((String)"Only versionable nodes can be checked in or out.")});
        } else {
            this.add(new Behavior[]{TitleAttribute.clear()});
        }
        this.redraw();
    }
}

