/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.icons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.hippoecm.frontend.plugins.console.icons.FontAwesomeIcon;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrNodeIcon {
    private static final Logger log = LoggerFactory.getLogger(JcrNodeIcon.class);
    private static final String CONTENT_ROOT = "/content";
    private static final String NODE_CSS_CLASS_PREFIX = "jcrnode-";
    private static final String DEFAULT_NODE_CSS_CLASS = "jcrnode-default";
    private static final String VIRTUAL_NODE_CSS_CLASS = "jcrnode-virtual";
    private static final String FACNAV_NODE_CSS_CLASS = "jcrnode-facnav";
    private static final String FA_CSS_CLASS = "fa";
    private static final String FA_DEFAULT_CSS_CLASS = FontAwesomeIcon.CIRCLE.cssClass();
    private static final String FA_VIRTUAL_NODE_CSS_CLASS = FontAwesomeIcon.CIRCLE_O.cssClass();
    private static final String FA_UNKNOWN_NODE_ICON_CLASS = FontAwesomeIcon.EXCLAMATION_CIRCLE.cssClass();
    public static final String FA_UNKNOWN_NODE_CSS_CLASS = "fa " + FA_UNKNOWN_NODE_ICON_CLASS + " " + "jcrnode-default";
    private static final List<String> nodeTypes = new ArrayList<String>();
    private static final Map<String, String> pathCssClass = new HashMap<String, String>();
    private static final Map<String, FontAwesomeIcon> primaryTypeNameIcons = new HashMap<String, FontAwesomeIcon>();

    public static String getIconCssClass(Node node) {
        if (node == null) {
            return FA_UNKNOWN_NODE_CSS_CLASS;
        }
        return "fa " + JcrNodeIcon.getIconTypeCssClass(node) + " " + JcrNodeIcon.getIconColorCssClass(node);
    }

    private static String getIconTypeCssClass(Node node) {
        for (String nodeType : nodeTypes) {
            if (!JcrNodeIcon.isNodeType(node, nodeType) || !primaryTypeNameIcons.containsKey(nodeType)) continue;
            return primaryTypeNameIcons.get(nodeType).cssClass();
        }
        String name = JcrNodeIcon.getPrimaryTypeName(node);
        if (primaryTypeNameIcons.containsKey(name)) {
            return primaryTypeNameIcons.get(name).cssClass();
        }
        if (JcrNodeIcon.isVirtual(node)) {
            return FA_VIRTUAL_NODE_CSS_CLASS;
        }
        return FA_DEFAULT_CSS_CLASS;
    }

    private static String getIconColorCssClass(Node node) {
        try {
            String path = node.getPath();
            if (path.startsWith(CONTENT_ROOT) && node.hasProperty("hippostd:state")) {
                return NODE_CSS_CLASS_PREFIX + node.getProperty("hippostd:state").getString();
            }
            if (JcrNodeIcon.isNodeType(node, "hippofacnav:facetnavigation")) {
                return FACNAV_NODE_CSS_CLASS;
            }
            if (JcrNodeIcon.isVirtual(node)) {
                return VIRTUAL_NODE_CSS_CLASS;
            }
            for (Map.Entry<String, String> pathColor : pathCssClass.entrySet()) {
                if (!path.startsWith(pathColor.getKey())) continue;
                return NODE_CSS_CLASS_PREFIX + pathColor.getValue();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return DEFAULT_NODE_CSS_CLASS;
    }

    private static String getPrimaryTypeName(Node node) {
        try {
            return node.getPrimaryNodeType().getName();
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    private static boolean isNodeType(Node node, String type) {
        try {
            return node.isNodeType(type);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static boolean isVirtual(Node node) {
        try {
            return JcrUtils.isVirtual((Node)node);
        }
        catch (RepositoryException e) {
            log.info("Cannot determine whether node '{}' is virtual, assuming it's not", (Object)JcrUtils.getNodePathQuietly((Node)node), (Object)e);
            return false;
        }
    }

    private JcrNodeIcon() {
    }

    static {
        nodeTypes.add("hippostd:publishable");
        primaryTypeNameIcons.put("hst:hst", FontAwesomeIcon.CLOUD);
        primaryTypeNameIcons.put("hst:sitemapitem", FontAwesomeIcon.SITEMAP);
        primaryTypeNameIcons.put("hst:sitemapitemhandlers", FontAwesomeIcon.COMPASS);
        primaryTypeNameIcons.put("hst:sitemapitemhandler", FontAwesomeIcon.COMPASS_ROTATE_90);
        primaryTypeNameIcons.put("hst:sitemap", FontAwesomeIcon.SITEMAP);
        primaryTypeNameIcons.put("hst:template", FontAwesomeIcon.FILE_TEXT_O);
        primaryTypeNameIcons.put("hst:templates", FontAwesomeIcon.FILE_O);
        primaryTypeNameIcons.put("hst:component", FontAwesomeIcon.PUZZLE_PIECE);
        primaryTypeNameIcons.put("hst:components", FontAwesomeIcon.PUZZLE_PIECE);
        primaryTypeNameIcons.put("hst:abstractcomponent", FontAwesomeIcon.PUZZLE_PIECE);
        primaryTypeNameIcons.put("hst:blueprint", FontAwesomeIcon.DROPBOX);
        primaryTypeNameIcons.put("hst:blueprints", FontAwesomeIcon.DROPBOX);
        primaryTypeNameIcons.put("hst:channels", FontAwesomeIcon.LAPTOP);
        primaryTypeNameIcons.put("hst:channel", FontAwesomeIcon.LAPTOP);
        primaryTypeNameIcons.put("hst:channelinfo", FontAwesomeIcon.INFO_CIRCLE);
        primaryTypeNameIcons.put("hst:sites", FontAwesomeIcon.STAR_O);
        primaryTypeNameIcons.put("hst:site", FontAwesomeIcon.STAR);
        primaryTypeNameIcons.put("hst:pages", FontAwesomeIcon.COPY);
        primaryTypeNameIcons.put("hst:workspace", FontAwesomeIcon.WRENCH);
        primaryTypeNameIcons.put("hst:catalog", FontAwesomeIcon.DROPBOX);
        primaryTypeNameIcons.put("hst:configuration", FontAwesomeIcon.COG);
        primaryTypeNameIcons.put("hst:configurations", FontAwesomeIcon.COGS);
        primaryTypeNameIcons.put("hst:mount", FontAwesomeIcon.ROCKET);
        primaryTypeNameIcons.put("hst:virtualhosts", FontAwesomeIcon.ARROW_CIRCLE_DOWN);
        primaryTypeNameIcons.put("hst:virtualhostgroup", FontAwesomeIcon.ARROW_CIRCLE_O_RIGHT);
        primaryTypeNameIcons.put("hst:virtualhost", FontAwesomeIcon.ARROW_CIRCLE_RIGHT);
        primaryTypeNameIcons.put("hippogallery:stdAssetGallery", FontAwesomeIcon.PAPERCLIP);
        primaryTypeNameIcons.put("hippogallery:stdImageGallery", FontAwesomeIcon.PICTURE_O);
        primaryTypeNameIcons.put("hst:containeritemcomponent", FontAwesomeIcon.CUBE);
        primaryTypeNameIcons.put("hst:containeritempackage", FontAwesomeIcon.DROPBOX);
        primaryTypeNameIcons.put("hst:containercomponent", FontAwesomeIcon.COLUMNS);
        primaryTypeNameIcons.put("hst:containercomponentfolder", FontAwesomeIcon.TRELLO);
        primaryTypeNameIcons.put("hst:sitemenus", FontAwesomeIcon.TH_LIST);
        primaryTypeNameIcons.put("hst:sitemenu", FontAwesomeIcon.TH_LIST);
        primaryTypeNameIcons.put("hst:sitemenuitem", FontAwesomeIcon.ALIGN_JUSTIFY);
        primaryTypeNameIcons.put("hippo:handle", FontAwesomeIcon.UMBRELLA);
        primaryTypeNameIcons.put("hippostd:publishable", FontAwesomeIcon.FILE_TEXT);
        primaryTypeNameIcons.put("hippo:translation", FontAwesomeIcon.FLAG_O);
        primaryTypeNameIcons.put("hippotranslation:translations", FontAwesomeIcon.RANDOM);
        primaryTypeNameIcons.put("hippostd:folder", FontAwesomeIcon.FOLDER_O);
        primaryTypeNameIcons.put("hippostd:directory", FontAwesomeIcon.FOLDER);
        primaryTypeNameIcons.put("hippofacnav:facetnavigation", FontAwesomeIcon.DRIBBBLE);
        primaryTypeNameIcons.put("hst:formdatacontainer", FontAwesomeIcon.SEND);
        primaryTypeNameIcons.put("hst:formdata", FontAwesomeIcon.SEND_O);
        primaryTypeNameIcons.put("hippotaxonomy:container", FontAwesomeIcon.BOOK);
        primaryTypeNameIcons.put("urlrewriter:ruleset", FontAwesomeIcon.CROSSHAIRS);
        primaryTypeNameIcons.put("webfiles:webfiles", FontAwesomeIcon.SUITCASE);
        primaryTypeNameIcons.put("webfiles:bundle", FontAwesomeIcon.SUITCASE);
        primaryTypeNameIcons.put("nt:folder", FontAwesomeIcon.FOLDER_O);
        primaryTypeNameIcons.put("nt:file", FontAwesomeIcon.FILE_TEXT_O);
        primaryTypeNameIcons.put("hipposys:configuration", FontAwesomeIcon.COGS);
        primaryTypeNameIcons.put("hipposysedit:namespacefolder", FontAwesomeIcon.BULLSEYE);
        primaryTypeNameIcons.put("hipposysedit:namespace", FontAwesomeIcon.BULLSEYE);
        primaryTypeNameIcons.put("frontend:plugin", FontAwesomeIcon.PLUG);
        primaryTypeNameIcons.put("frontend:pluginconfig", FontAwesomeIcon.COG);
        primaryTypeNameIcons.put("frontend:plugincluster", FontAwesomeIcon.COGS);
        primaryTypeNameIcons.put("editor:templateset", FontAwesomeIcon.FILE_TEXT_O);
        primaryTypeNameIcons.put("hipposysedit:prototypeset", FontAwesomeIcon.STAR_O);
        primaryTypeNameIcons.put("hipposysedit:templatetype", FontAwesomeIcon.FILE_TEXT);
        primaryTypeNameIcons.put("hipposys:group", FontAwesomeIcon.USERS);
        primaryTypeNameIcons.put("hipposys:groupfolder", FontAwesomeIcon.USERS);
        primaryTypeNameIcons.put("hipposys:userfolder", FontAwesomeIcon.USER);
        primaryTypeNameIcons.put("hipposys:user", FontAwesomeIcon.USER);
        primaryTypeNameIcons.put("hipposys:workflowfolder", FontAwesomeIcon.REFRESH);
        primaryTypeNameIcons.put("hipposys:workflowcategory", FontAwesomeIcon.REFRESH);
        primaryTypeNameIcons.put("hipposys:workflow", FontAwesomeIcon.REFRESH);
        primaryTypeNameIcons.put("hipposys:update", FontAwesomeIcon.WRENCH);
        primaryTypeNameIcons.put("hipposys:applicationfolder", FontAwesomeIcon.DIAMOND);
        primaryTypeNameIcons.put("hipposys:modulefolder", FontAwesomeIcon.SIMPLYBUILT);
        primaryTypeNameIcons.put("hipposys:queryfolder", FontAwesomeIcon.QUESTION_CIRCLE);
        primaryTypeNameIcons.put("hipposys:queryfolder", FontAwesomeIcon.QUESTION_CIRCLE);
        primaryTypeNameIcons.put("hippostd:templatequery", FontAwesomeIcon.QUESTION);
        primaryTypeNameIcons.put("hipposys:resourcebundles", FontAwesomeIcon.BOOKMARK_O);
        primaryTypeNameIcons.put("hipposys:resourcebundle", FontAwesomeIcon.BOOKMARK);
        primaryTypeNameIcons.put("hipposys:domainfolder", FontAwesomeIcon.SHIELD);
        primaryTypeNameIcons.put("hipposys:domain", FontAwesomeIcon.SHIELD_ROTATE_270);
        primaryTypeNameIcons.put("hipposys:domainrule", FontAwesomeIcon.SHIELD_ROTATE_270);
        primaryTypeNameIcons.put("hipposys:facetrule", FontAwesomeIcon.PIECHART);
        primaryTypeNameIcons.put("hipposys:authrole", FontAwesomeIcon.USER_PLUS);
        primaryTypeNameIcons.put("targeting:experiments", FontAwesomeIcon.FLASK);
        primaryTypeNameIcons.put("targeting:experiment", FontAwesomeIcon.FLASK);
        primaryTypeNameIcons.put("targeting:experimentsfolder", FontAwesomeIcon.FOLDER_O);
        primaryTypeNameIcons.put("targeting:configuration", FontAwesomeIcon.DASHBOARD);
        primaryTypeNameIcons.put("targeting:collectors", FontAwesomeIcon.STEAM);
        primaryTypeNameIcons.put("targeting:collector", FontAwesomeIcon.STEAM);
        primaryTypeNameIcons.put("targeting:personas", FontAwesomeIcon.STREETVIEW);
        primaryTypeNameIcons.put("targeting:persona", FontAwesomeIcon.STREETVIEW);
        primaryTypeNameIcons.put("targeting:goals", FontAwesomeIcon.ASTERISK);
        primaryTypeNameIcons.put("targeting:goal", FontAwesomeIcon.ASTERISK);
        primaryTypeNameIcons.put("targeting:characteristics", FontAwesomeIcon.SLACK);
        primaryTypeNameIcons.put("targeting:characteristic", FontAwesomeIcon.SLACK);
        primaryTypeNameIcons.put("targeting:datastores", FontAwesomeIcon.DATABASE);
        primaryTypeNameIcons.put("targeting:datastore", FontAwesomeIcon.DATABASE);
        primaryTypeNameIcons.put("targeting:alteregos", FontAwesomeIcon.USER_SECRET);
        primaryTypeNameIcons.put("targeting:alterego", FontAwesomeIcon.USER_SECRET);
        primaryTypeNameIcons.put("targeting:dataflow", FontAwesomeIcon.LOCK);
        primaryTypeNameIcons.put("targeting:lock", FontAwesomeIcon.LOCK);
        primaryTypeNameIcons.put("targeting:statistics", FontAwesomeIcon.BAR_CHART);
        primaryTypeNameIcons.put("targeting:statistic", FontAwesomeIcon.BAR_CHART);
        primaryTypeNameIcons.put("targeting:trends", FontAwesomeIcon.LINE_CHART);
        primaryTypeNameIcons.put("targeting:facets", FontAwesomeIcon.LINE_CHART);
        primaryTypeNameIcons.put("targeting:conversions", FontAwesomeIcon.SMILE_O);
        primaryTypeNameIcons.put("targeting:events", FontAwesomeIcon.CLOCK_O);
        primaryTypeNameIcons.put("targeting:event", FontAwesomeIcon.CLOCK_O);
        primaryTypeNameIcons.put("targeting:andexpression", FontAwesomeIcon.ANGLE_DOUBLE_RIGHT);
        primaryTypeNameIcons.put("targeting:orexpression", FontAwesomeIcon.ANGLE_DOUBLE_RIGHT);
        primaryTypeNameIcons.put("targeting:expression", FontAwesomeIcon.ANGLE_DOUBLE_RIGHT);
        primaryTypeNameIcons.put("targeting:negate", FontAwesomeIcon.ANGLE_DOUBLE_RIGHT);
        primaryTypeNameIcons.put("targeting:abstractandexpression", FontAwesomeIcon.ANGLE_DOUBLE_RIGHT);
        primaryTypeNameIcons.put("targeting:services", FontAwesomeIcon.SUN_O);
        primaryTypeNameIcons.put("targeting:service", FontAwesomeIcon.CERTIFICATE);
        pathCssClass.put("/hst:hst", "hst");
        pathCssClass.put("/hippo:configuration", "conf");
        pathCssClass.put(CONTENT_ROOT, "content");
        pathCssClass.put("/hippo:namespaces", "namespaces");
        pathCssClass.put("/formdata", "formdata");
        pathCssClass.put("/webfiles", "webfiles");
        pathCssClass.put("/hippo:reports", "reports");
        pathCssClass.put("/hippo:log", "log");
        pathCssClass.put("/targeting:targeting", "targeting");
    }
}

