/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.util.io.IClusterable;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.Plugin;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.editor.NodeEditor;
import org.hippoecm.frontend.plugins.console.editor.ReferenceEditor;
import org.hippoecm.frontend.plugins.console.editor.ValueEditorFactory;

public class ReferenceEditorPlugin
extends Plugin
implements ValueEditorFactory {
    public ReferenceEditorPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        context.registerService((IClusterable)this, "service.editor.valuefactory");
    }

    @Override
    public boolean canEdit(JcrPropertyValueModel valueModel) {
        if (valueModel == null) {
            return false;
        }
        try {
            Property property = valueModel.getJcrPropertymodel().getProperty();
            return property.getType() == 9 || property.getName().equals("hippo:docbase");
        }
        catch (RepositoryException e) {
            NodeEditor.log.error(e.getMessage());
            return false;
        }
    }

    @Override
    public Component createEditor(String id, JcrPropertyValueModel valueModel) {
        return new ReferenceEditor(id, valueModel.getJcrPropertymodel(), (JcrPropertyValueModel<String>)valueModel);
    }
}

