/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.plugins.console.editor.FreemarkerCodeMirrorPropertyValueEditor;
import org.hippoecm.frontend.plugins.console.editor.JcrName;
import org.hippoecm.frontend.plugins.console.editor.NodeEditor;
import org.hippoecm.frontend.plugins.console.editor.PropertyValueEditor;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesEditor
extends DataView<Property> {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(PropertiesEditor.class);
    private String namespacePrefix;

    public PropertiesEditor(String id, IDataProvider<Property> model) {
        super(id, model);
        this.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        String namespace = ((NodeEditor.NamespacePropertiesProvider)model).getNamespace();
        this.namespacePrefix = namespace.equals("<none>") ? "" : namespace + ":";
    }

    protected void populateItem(Item item) {
        JcrPropertyModel model = (JcrPropertyModel)item.getModel();
        try {
            AjaxLink deleteLink = this.deleteLink("delete", model);
            item.add(new Component[]{deleteLink});
            deleteLink.setVisible(!model.getProperty().getDefinition().isProtected());
            JcrName propName = new JcrName(model.getProperty().getName());
            item.add(new Component[]{new Label("namespace", this.namespacePrefix)});
            item.add(new Component[]{new Label("name", propName.getName())});
            item.add(new Component[]{new Label("type", PropertyType.nameFromValue((int)model.getProperty().getType()))});
            WebMarkupContainer valuesContainer = new WebMarkupContainer("values-container");
            valuesContainer.setOutputMarkupId(true);
            item.add(new Component[]{valuesContainer});
            PropertyValueEditor editor = this.createPropertyValueEditor("values", model);
            valuesContainer.add(new Component[]{editor});
            AjaxLink addLink = this.addLink("add", model, valuesContainer, editor);
            addLink.add(new Behavior[]{TitleAttribute.set((String)this.getString("property.value.add"))});
            item.add(new Component[]{addLink});
            PropertyDefinition definition = model.getProperty().getDefinition();
            addLink.setVisible(definition.isMultiple() && !definition.isProtected());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
    }

    protected PropertyValueEditor createPropertyValueEditor(String id, JcrPropertyModel model) throws RepositoryException {
        Property prop = model.getProperty();
        if ("hst:script".equals(prop.getName()) && prop.getParent().isNodeType("hst:template")) {
            return new FreemarkerCodeMirrorPropertyValueEditor(id, model);
        }
        return new PropertyValueEditor(id, model);
    }

    private AjaxLink deleteLink(String id, final JcrPropertyModel model) throws RepositoryException {
        AjaxLink<Property> deleteLink = new AjaxLink<Property>(id, (IModel)model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("class", (CharSequence)"property-remove");
            }

            public void onClick(AjaxRequestTarget target) {
                try {
                    Property prop = model.getProperty();
                    prop.remove();
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
                NodeEditor editor = (NodeEditor)((Object)this.findParent(NodeEditor.class));
                target.add(new Component[]{editor});
            }
        };
        deleteLink.add(new Behavior[]{TitleAttribute.set((String)this.getString("property.remove"))});
        return deleteLink;
    }

    private AjaxLink addLink(String id, final JcrPropertyModel model, final WebMarkupContainer component, final PropertyValueEditor editor) {
        return new AjaxLink<Property>(id, (IModel)model){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                Property prop = model.getProperty();
                try {
                    Value[] oldValues = prop.getValues();
                    Value[] newValues = new Value[oldValues.length + 1];
                    System.arraycopy(oldValues, 0, newValues, 0, oldValues.length);
                    newValues[newValues.length - 1] = PropertiesEditor.this.createDefaultValue(prop.getType());
                    prop.setValue(newValues);
                    editor.setFocusOnLastItem(true);
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                    return;
                }
                target.add(new Component[]{component});
            }
        };
    }

    private Value createDefaultValue(int valueType) throws RepositoryException {
        ValueFactory valueFactory = UserSession.get().getJcrSession().getValueFactory();
        switch (valueType) {
            case 6: {
                return valueFactory.createValue(false);
            }
            case 5: {
                return valueFactory.createValue(Calendar.getInstance());
            }
            case 12: {
                return valueFactory.createValue(new BigDecimal(0.0));
            }
            case 4: {
                return valueFactory.createValue(0.0);
            }
            case 3: {
                return valueFactory.createValue(0L);
            }
            case 7: {
                return valueFactory.createValue("jcr:name", 7);
            }
            case 8: {
                return valueFactory.createValue("/", 8);
            }
            case 11: {
                return valueFactory.createValue("http://www.onehippo.org/", 11);
            }
            case 9: {
                return valueFactory.createValue("cafebabe-cafe-babe-cafe-babecafebabe", 9);
            }
            case 10: {
                return valueFactory.createValue("cafebabe-cafe-babe-cafe-babecafebabe", 9);
            }
        }
        return valueFactory.createValue("");
    }
}

