/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import com.google.common.base.Strings;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.widgets.TextFieldWidget;
import org.hippoecm.repository.PasswordHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordHashEditor
extends Panel {
    public static final String CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PasswordHashEditor.class);
    private final int passwordLength;
    private final TextFieldWidget passwordField;

    public PasswordHashEditor(String id, int passwordLength, JcrPropertyModel propertyModel, IModel<String> valueModel) {
        super(id);
        this.passwordLength = passwordLength;
        this.setOutputMarkupId(true);
        PasswordGenerateLink generateLink = new PasswordGenerateLink("password-generate-link", propertyModel, valueModel);
        this.add(new Component[]{generateLink});
        PasswordHashLink hashLink = new PasswordHashLink("password-hash-link", propertyModel, valueModel);
        this.add(new Component[]{hashLink});
        this.passwordField = new TextFieldWidget("password-input", valueModel){

            protected void onUpdate(AjaxRequestTarget target) {
                target.focusComponent((Component)this);
                target.add(new Component[]{PasswordHashEditor.this});
            }
        };
        this.passwordField.setOutputMarkupId(true);
        this.passwordField.setSize("60");
        this.add(new Component[]{this.passwordField});
    }

    private static String genPassword(int len) {
        Random rnd = new Random();
        char[] password = new char[len];
        for (int i = 0; i < len; ++i) {
            password[i] = CHARACTERS.charAt(rnd.nextInt(CHARACTERS.length()));
        }
        return new String(password);
    }

    public static String createPasswordHash(String password) {
        try {
            return PasswordHelper.getHash((char[])password.toCharArray());
        }
        catch (IOException | NoSuchAlgorithmException e) {
            log.error("Unable to hash password", (Throwable)e);
            return null;
        }
    }

    private class PasswordHashLink
    extends AjaxLink<String> {
        private static final long serialVersionUID = 1L;
        private String linkText;
        private final JcrPropertyModel propertyModel;

        public PasswordHashLink(String id, JcrPropertyModel propertyModel, IModel<String> valueModel) {
            super(id, valueModel);
            this.propertyModel = propertyModel;
            this.linkText = "Hash password";
            this.add(new Component[]{new Label("password-hash-link-text", (IModel)new PropertyModel((Object)this, "linkText"))});
            this.add(new Behavior[]{new AttributeAppender("style", (IModel)new AbstractReadOnlyModel<Object>(){

                public Object getObject() {
                    return "color:blue";
                }
            }, " ")});
        }

        protected boolean isLinkEnabled() {
            return true;
        }

        public void onClick(AjaxRequestTarget target) {
            String password = (String)this.getModelObject();
            if (Strings.isNullOrEmpty((String)password)) {
                log.warn("Password null or empty, generate new password first");
                return;
            }
            if (password.startsWith("$SHA-")) {
                log.warn("Already hashed: Please generate password first");
                return;
            }
            String passwordHash = PasswordHashEditor.createPasswordHash(password);
            if (!Strings.isNullOrEmpty((String)passwordHash)) {
                try {
                    Property property = this.propertyModel.getProperty();
                    property.setValue(passwordHash);
                }
                catch (RepositoryException e) {
                    log.error("Error generating password", (Throwable)e);
                }
            }
            target.add(new Component[]{PasswordHashEditor.this});
        }
    }

    private class PasswordGenerateLink
    extends AjaxLink<String> {
        private static final long serialVersionUID = 1L;
        private String linkText;
        private final JcrPropertyModel propertyModel;

        public PasswordGenerateLink(String id, JcrPropertyModel propertyModel, IModel<String> valueModel) {
            super(id, valueModel);
            this.propertyModel = propertyModel;
            this.linkText = "Generate random password";
            this.add(new Component[]{new Label("password-generate-link-text", (IModel)new PropertyModel((Object)this, "linkText"))});
            this.add(new Behavior[]{new AttributeAppender("style", (IModel)new AbstractReadOnlyModel<Object>(){

                public Object getObject() {
                    return "color:blue";
                }
            }, " ")});
        }

        protected boolean isLinkEnabled() {
            return true;
        }

        public void onClick(AjaxRequestTarget target) {
            String password = PasswordHashEditor.genPassword(PasswordHashEditor.this.passwordLength);
            if (!Strings.isNullOrEmpty((String)password)) {
                try {
                    Property property = this.propertyModel.getProperty();
                    property.setValue(password);
                    target.add(new Component[]{PasswordHashEditor.this.passwordField});
                    target.focusComponent((Component)PasswordHashEditor.this.passwordField);
                }
                catch (RepositoryException e) {
                    log.error("Error generating password", (Throwable)e);
                }
            }
        }
    }
}

