/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.NodeModelWrapper;
import org.hippoecm.frontend.session.UserSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeTypesEditor
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(NodeTypesEditor.class);

    NodeTypesEditor(String id, IModel<Node> nodeModel) {
        super(id, nodeModel);
        this.setOutputMarkupId(true);
        this.add(new Component[]{new ListView<String>("type", this.getAllNodeTypes()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                IModel model = item.getModel();
                String type = (String)model.getObject();
                IModel<Node> defaultModel = NodeTypesEditor.this.getModel();
                AjaxCheckBox check = new AjaxCheckBox("check", (IModel)new MixinModel(defaultModel, type)){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        target.add(new Component[]{NodeTypesEditor.this});
                    }

                    public boolean isEnabled() {
                        MixinModel mixinModel = (MixinModel)this.getModel();
                        return !mixinModel.isInherited();
                    }
                };
                item.add(new Component[]{check});
                check.add(new Component[]{new Label("name", type).add(new Behavior[]{new AttributeAppender("for", (Serializable)((Object)check.getMarkupId()))})});
            }
        }});
    }

    public IModel<Node> getModel() {
        return this.getDefaultModel();
    }

    public void setModel(IModel<Node> model) {
        this.setDefaultModel(model);
    }

    public String getMixinTypes() {
        Node node = (Node)this.getDefaultModelObject();
        if (node != null) {
            try {
                Collection<String> declaredMixinTypes = this.getDeclaredMixinTypes(node);
                Collection<String> inheritedMixinTypes = this.getInheritedMixinTypes(node);
                ArrayList<String> allMixinTypes = new ArrayList<String>(declaredMixinTypes);
                allMixinTypes.addAll(inheritedMixinTypes);
                return StringUtils.join(allMixinTypes, (String)", ");
            }
            catch (RepositoryException re) {
                log.error(re.getMessage());
            }
        }
        return "";
    }

    private Collection<String> getDeclaredMixinTypes(Node node) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            result.add(nodeType.getName());
        }
        return result;
    }

    private Collection<String> getInheritedMixinTypes(Node node) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        for (NodeType nodeType : node.getMixinNodeTypes()) {
            for (NodeType superType : nodeType.getSupertypes()) {
                if (!superType.isMixin()) continue;
                result.add(superType.getName());
            }
        }
        for (NodeType nodeType : node.getPrimaryNodeType().getSupertypes()) {
            if (!nodeType.isMixin()) continue;
            result.add(nodeType.getName());
        }
        return result;
    }

    private List<String> getAllNodeTypes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            Session session = UserSession.get().getJcrSession();
            NodeTypeManager ntmgr = session.getWorkspace().getNodeTypeManager();
            NodeTypeIterator iterator = ntmgr.getMixinNodeTypes();
            while (iterator.hasNext()) {
                result.add(iterator.nextNodeType().getName());
            }
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        Collections.sort(result);
        return result;
    }

    private static class MixinModel
    extends NodeModelWrapper<Boolean> {
        private static final long serialVersionUID = 1L;
        private String type;

        private MixinModel(IModel<Node> nodeModel, String mixin) {
            super(nodeModel);
            this.type = mixin;
        }

        public Boolean getObject() {
            try {
                return this.isNodeType();
            }
            catch (RepositoryException ex) {
                log.error(ex.getMessage());
                return false;
            }
        }

        public void setObject(Boolean value) {
            try {
                Node node = this.getNode();
                if (node == null) {
                    throw new UnsupportedOperationException();
                }
                if (value.booleanValue()) {
                    if (!this.isNodeType()) {
                        node.addMixin(this.type);
                    }
                } else if (this.isNodeType() && this.hasMixin()) {
                    node.removeMixin(this.type);
                }
            }
            catch (RepositoryException ex) {
                log.error(ex.getMessage());
            }
        }

        private boolean isNodeType() throws RepositoryException {
            Node node = this.getNode();
            if (node == null) {
                return false;
            }
            return node.isNodeType(this.type);
        }

        private boolean hasMixin() throws RepositoryException {
            Node node = this.getNode();
            if (node == null) {
                return false;
            }
            for (NodeType nodeType : node.getMixinNodeTypes()) {
                if (!nodeType.getName().equals(this.type)) continue;
                return true;
            }
            return false;
        }

        public boolean isInherited() {
            try {
                return this.isNodeType() && !this.hasMixin();
            }
            catch (RepositoryException re) {
                log.error(re.getMessage());
                return false;
            }
        }
    }
}

