/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.EmptyDataProvider;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.properties.JcrPropertiesProvider;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.plugins.console.editor.JcrName;
import org.hippoecm.frontend.plugins.console.editor.NodeTypesEditor;
import org.hippoecm.frontend.plugins.console.editor.PropertiesEditor;
import org.hippoecm.frontend.plugins.console.editor.ToggleHeader;
import org.hippoecm.frontend.plugins.console.icons.IconLabel;
import org.hippoecm.frontend.plugins.console.icons.JcrNodeIcon;
import org.hippoecm.frontend.widgets.TextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeEditor
extends Form<Node> {
    private static final long serialVersionUID = 1L;
    static final Logger log = LoggerFactory.getLogger(NodeEditor.class);
    private static final NamespacePropertyComparator PROPERTY_COMPARATOR = new NamespacePropertyComparator();
    public static final String NONE_LABEL = "<none>";
    private String name;
    private String uuid;
    private String nodePath;
    private NamespaceProvider namespaceProvider;
    private NamespacePropertiesEditor namespacePropertiesEditor;
    private NodeTypesEditor typesEditor;

    NodeEditor(String id, IModel<Node> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.add(new Component[]{new ToggleHeader("toggle-header-0", "0", "General")});
        this.add(new Component[]{new IconLabel("nodeIcon", (IModel<String>)new LoadableDetachableModel<String>(){

            protected String load() {
                return JcrNodeIcon.getIconCssClass((Node)NodeEditor.this.getModelObject());
            }
        })});
        this.add(new Component[]{new Label("nodePath", (IModel)new PropertyModel((Object)this, "nodePath"))});
        this.add(new Component[]{new Label("name", (IModel)new PropertyModel((Object)this, "name"))});
        this.add(new Component[]{new Label("uuid", (IModel)new PropertyModel((Object)this, "uuid"))});
        this.add(new Component[]{new ToggleHeader("toggle-header-1", "1", "Types")});
        TextFieldWidget primaryTypeWidget = new TextFieldWidget("primarytype", (IModel)new PropertyModel((Object)this, "primaryType"));
        primaryTypeWidget.setSize("40");
        this.add(new Component[]{primaryTypeWidget});
        this.typesEditor = new NodeTypesEditor("mixintypes", model);
        this.add(new Component[]{this.typesEditor});
        this.add(new Component[]{new Label("types", (IModel)new PropertyModel((Object)this.typesEditor, "mixinTypes"))});
        this.add(new Component[]{new ToggleHeader("toggle-header-2", "2", "Properties")});
        this.namespaceProvider = new NamespaceProvider((IDataProvider<Property>)new EmptyDataProvider());
        this.namespacePropertiesEditor = new NamespacePropertiesEditor("namespaces", this.namespaceProvider);
        this.add(new Component[]{this.namespacePropertiesEditor});
        this.add(new Component[]{new ToggleHeader("toggle-header-3", "3", "Mixin Types")});
        this.onModelChanged();
    }

    public void onModelChanged() {
        super.onModelChanged();
        IModel model = this.getModel();
        if (model != null && model.getObject() != null) {
            Node node = (Node)model.getObject();
            try {
                this.namespaceProvider.setWrapped((IDataProvider<Property>)new JcrPropertiesProvider(new JcrNodeModel(node)));
                this.nodePath = node.getPath();
                this.name = node.getName();
                this.uuid = node.getIdentifier();
                this.typesEditor.setModel((IModel<Node>)this.getModel());
                this.typesEditor.setVisible(true);
                this.namespacePropertiesEditor.setVisible(true);
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        } else {
            this.typesEditor.setVisible(false);
            this.namespacePropertiesEditor.setVisible(false);
        }
    }

    public String getPrimaryType() {
        Node node = (Node)this.getModelObject();
        if (node != null) {
            try {
                return node.getPrimaryNodeType().getName();
            }
            catch (RepositoryException e) {
                log.error(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public void setPrimaryType(String primaryType) {
        Node node = (Node)this.getModelObject();
        if (node != null) {
            String oldPrimaryType = null;
            try {
                oldPrimaryType = node.getPrimaryNodeType().getName();
                node.setPrimaryType(primaryType);
            }
            catch (ConstraintViolationException e) {
                log.error("Cannot set primary type to {}", (Object)primaryType);
                if (oldPrimaryType != null) {
                    try {
                        node.setPrimaryType(oldPrimaryType);
                    }
                    catch (RepositoryException e1) {
                        log.error("Failed to set primary node type to previous value");
                    }
                }
            }
            catch (RepositoryException e) {
                log.error("Failed to set primary node type", (Throwable)e);
            }
        }
    }

    private static class NamespacePropertyComparator
    implements Comparator<Property> {
        private static final long serialVersionUID = 1L;

        private NamespacePropertyComparator() {
        }

        @Override
        public int compare(Property p1, Property p2) {
            try {
                if (p1 == null) {
                    if (p2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                return p1.getName().compareTo(p2.getName());
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Error while comparing properties", e);
            }
        }
    }

    protected static class NamespacePropertiesProvider
    implements IDataProvider<Property> {
        private static final long serialVersionUID = 1L;
        private final String namespace;
        private List<Property> properties;
        private boolean sorted;

        NamespacePropertiesProvider(String namespace) {
            this.namespace = namespace;
            this.properties = new ArrayList<Property>();
            this.sorted = true;
        }

        public String getNamespace() {
            return this.namespace;
        }

        void addProperty(Property p) {
            this.properties.add(p);
            if (this.properties.size() > 1) {
                this.sorted = false;
            }
        }

        public Iterator<Property> iterator(long first, long count) {
            if (!this.sorted) {
                Collections.sort(this.properties, PROPERTY_COMPARATOR);
                this.sorted = true;
            }
            return this.properties.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            return this.properties.size();
        }

        public IModel<Property> model(Property object) {
            return new JcrPropertyModel(object);
        }

        public void detach() {
            this.properties = null;
        }
    }

    private static class NamespaceProvider
    implements IDataProvider<NamespacePropertiesProvider> {
        private static final long serialVersionUID = 1L;
        private List<NamespacePropertiesProvider> namespaces;
        private IDataProvider<Property> wrapped;

        NamespaceProvider(IDataProvider<Property> wrapped) {
            this.wrapped = wrapped;
            this.namespaces = Collections.emptyList();
        }

        void setWrapped(IDataProvider<Property> wrapped) {
            this.wrapped = wrapped;
        }

        public Iterator<? extends NamespacePropertiesProvider> iterator(long first, long count) {
            this.load();
            return this.namespaces.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            this.load();
            return this.namespaces.size();
        }

        public IModel<NamespacePropertiesProvider> model(NamespacePropertiesProvider object) {
            return Model.of((Serializable)((Object)object));
        }

        public void detach() {
            this.namespaces = null;
            this.wrapped.detach();
        }

        private void load() {
            this.namespaces = new ArrayList<NamespacePropertiesProvider>();
            TreeMap<String, NamespacePropertiesProvider> namespaceMap = new TreeMap<String, NamespacePropertiesProvider>();
            try {
                Iterator it = this.wrapped.iterator(0L, this.wrapped.size());
                while (it.hasNext()) {
                    NamespacePropertiesProvider propertiesProvider;
                    Property p = (Property)it.next();
                    String propName = p.getName();
                    if (propName.equals("jcr:primaryType") || propName.equals("jcr:mixinTypes")) continue;
                    String propNamespace = new JcrName(propName).getNamespace();
                    if (propNamespace == null) {
                        propNamespace = NodeEditor.NONE_LABEL;
                    }
                    if ((propertiesProvider = (NamespacePropertiesProvider)namespaceMap.get(propNamespace)) == null) {
                        propertiesProvider = new NamespacePropertiesProvider(propNamespace);
                        namespaceMap.put(propNamespace, propertiesProvider);
                    }
                    propertiesProvider.addProperty(p);
                }
                this.namespaces.addAll(namespaceMap.values());
            }
            catch (RepositoryException ex) {
                log.error(ex.getMessage());
            }
        }
    }

    private static class NamespacePropertiesEditor
    extends DataView<NamespacePropertiesProvider> {
        private static final long serialVersionUID = 1L;

        protected NamespacePropertiesEditor(String id, IDataProvider<NamespacePropertiesProvider> dataProvider) {
            super(id, dataProvider);
        }

        protected void populateItem(Item<NamespacePropertiesProvider> item) {
            NamespacePropertiesProvider propertiesProvider = (NamespacePropertiesProvider)item.getModelObject();
            String namespace = propertiesProvider.getNamespace();
            String namespaceHeading = namespace + " (" + propertiesProvider.size() + ")";
            ToggleHeader toggleHeader = new ToggleHeader("toggle-namespace", namespace, namespaceHeading);
            toggleHeader.setMarkupId("toggle-header-" + namespace);
            toggleHeader.setOutputMarkupId(true);
            item.add(new Component[]{toggleHeader});
            WebMarkupContainer propertiesContainer = new WebMarkupContainer("propertiesContainer");
            propertiesContainer.setOutputMarkupId(true);
            propertiesContainer.setMarkupId("toggle-box-" + namespace);
            PropertiesEditor propertiesEditor = new PropertiesEditor("properties", propertiesProvider);
            propertiesContainer.add(new Component[]{propertiesEditor});
            item.add(new Component[]{propertiesContainer});
        }
    }
}

