/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.plugins.console.icons.FontAwesomeIcon;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.TextAreaWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstRenderPathEditor
extends Panel {
    static final Logger log = LoggerFactory.getLogger(HstRenderPathEditor.class);
    protected static final String PROPERTY_HST_RENDERPATH = "hst:renderpath";
    protected static final String NODE_WEBFILES = "/webfiles";
    protected static final String WEBFILE_PREFIX = "webfile:/";

    public HstRenderPathEditor(String id, IModel<String> valueModel) {
        super(id);
        this.setOutputMarkupId(true);
        String propertyValue = (String)valueModel.getObject();
        Label validationIcon = new Label("validation-icon", "");
        this.add(new Component[]{validationIcon});
        this.determineIcon(validationIcon, propertyValue);
        TextAreaWidget editor = new TextAreaWidget("reference-edit", valueModel);
        editor.setRows("1");
        this.add(new Component[]{editor});
    }

    private void determineIcon(Label validationIcon, String propertyValue) {
        if (StringUtils.isBlank((String)propertyValue) || !propertyValue.startsWith(WEBFILE_PREFIX)) {
            validationIcon.setVisible(false);
            return;
        }
        ArrayList<String> webFilePaths = new ArrayList<String>();
        try {
            Session jcrSession = UserSession.get().getJcrSession();
            for (String bundlePath : this.getWebfileBundlePaths()) {
                String webfilePath = bundlePath + '/' + propertyValue.substring(WEBFILE_PREFIX.length());
                if (!jcrSession.itemExists(webfilePath)) continue;
                webFilePaths.add(webfilePath);
            }
        }
        catch (RepositoryException e) {
            log.error("Cannot retrieve webfiles node.", (Throwable)e);
            validationIcon.setVisible(false);
            return;
        }
        switch (webFilePaths.size()) {
            case 0: {
                validationIcon.add(new Behavior[]{CssClass.append((String)(FontAwesomeIcon.EXCLAMATION.cssClass() + " check-false"))});
                validationIcon.add(new Behavior[]{TitleAttribute.append((String)"Web File not found at this path.")});
                break;
            }
            case 1: {
                validationIcon.add(new Behavior[]{CssClass.append((String)(FontAwesomeIcon.CHECK.cssClass() + " check-ok"))});
                validationIcon.add(new Behavior[]{TitleAttribute.append((String)("Web File Found at path " + (String)webFilePaths.get(0)))});
                break;
            }
            default: {
                validationIcon.add(new Behavior[]{CssClass.append((String)(FontAwesomeIcon.CHECK.cssClass() + " check-ok"))});
                validationIcon.add(new Behavior[]{TitleAttribute.append((String)("Web File Found at multiple paths: " + StringUtils.join(webFilePaths, (String)", ")))});
            }
        }
    }

    private ArrayList<String> getWebfileBundlePaths() {
        ArrayList<String> webfileBundlePaths = new ArrayList<String>();
        try {
            Node webfilesNode = UserSession.get().getJcrSession().getNode(NODE_WEBFILES);
            NodeIterator nodeIterator = webfilesNode.getNodes();
            while (nodeIterator.hasNext()) {
                webfileBundlePaths.add(nodeIterator.nextNode().getPath());
            }
        }
        catch (PathNotFoundException e) {
            log.warn(String.format("Webfiles not found at path %s. Cannot check hst:renderpath properties that reference web files.", NODE_WEBFILES));
        }
        catch (RepositoryException e) {
            log.error("Cannot retrieve webfiles node.", (Throwable)e);
        }
        return webfileBundlePaths;
    }
}

