/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.hippoecm.frontend.plugins.cms.codemirror.CodeMirrorEditor;
import org.hippoecm.frontend.plugins.console.editor.CodeMirrorTextAreaWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerTextAreaWidget
extends CodeMirrorTextAreaWidget {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(FreemarkerTextAreaWidget.class);

    public FreemarkerTextAreaWidget(String id, IModel<String> model) {
        super(id, model);
    }

    @Override
    protected CodeMirrorEditor createEditor(IModel<String> model) {
        return new FreemarkerCodeMirrorEditor("widget", "ftl-code-editor", model);
    }

    private class FreemarkerCodeMirrorEditor
    extends CodeMirrorEditor {
        private static final long serialVersionUID = 1L;

        public FreemarkerCodeMirrorEditor(String id, String editorName, IModel<String> model) {
            super(id, editorName, model);
            this.setFlag(256, false);
            this.setEditorMode("text/html");
            this.setChangeEventTriggeringEnabled(true);
        }

        protected void renderHeadForCustomModes(IHeaderResponse response) {
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)XML_MODE_JS));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JAVASCRIPT_MODE_JS));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)CSS_MODE_JS));
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)HTML_MIXED_MODE_JS));
        }
    }
}

