/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.editor.EditorUpdate;
import org.hippoecm.frontend.plugins.console.editor.NodeEditor;
import org.hippoecm.frontend.plugins.yui.togglebehavior.ToggleBehavior;
import org.hippoecm.frontend.service.render.RenderPlugin;

public class EditorPlugin
extends RenderPlugin<Node> {
    private static final long serialVersionUID = 1L;
    private final NodeEditor editor = new NodeEditor("editor", (IModel<Node>)this.getModel());

    public EditorPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        this.add(new Component[]{this.editor});
        this.add(new Behavior[]{new ToggleBehavior()});
    }

    protected IPluginContext getPluginContext() {
        return super.getPluginContext();
    }

    public void onModelChanged() {
        super.onModelChanged();
        IModel newModel = this.getModel();
        try {
            Node node = (Node)newModel.getObject();
            if (node != null) {
                if (node.isCheckedOut()) {
                    this.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)""))});
                } else {
                    this.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"background-color:#ddd;"))});
                }
                this.redraw();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        if (!this.editor.getModel().equals(newModel)) {
            this.editor.setModel(newModel);
            this.redraw();
        }
    }

    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof EditorUpdate) {
            this.redraw();
            EditorUpdate update = (EditorUpdate)event.getPayload();
            update.getTarget().add(new Component[]{this});
        }
    }
}

