/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.model.properties.JcrPropertyValueModel;
import org.hippoecm.frontend.model.properties.StringConverter;
import org.hippoecm.frontend.plugins.console.editor.CodeMirrorTextAreaWidget;
import org.hippoecm.frontend.plugins.console.editor.PropertyValueEditor;
import org.hippoecm.frontend.widgets.TextAreaWidget;

public class CodeMirrorPropertyValueEditor
extends PropertyValueEditor {
    private static final long serialVersionUID = 1L;
    private static final int MIN_ROWS = 10;

    CodeMirrorPropertyValueEditor(String id, JcrPropertyModel dataProvider) {
        super(id, dataProvider);
    }

    @Override
    protected Component createValueEditor(JcrPropertyValueModel valueModel) throws RepositoryException {
        StringConverter stringModel = new StringConverter(valueModel);
        TextAreaWidget editor = this.createEditorWidget("value", (IModel<String>)stringModel);
        editor.setCols(String.valueOf(100));
        editor.setRows(String.valueOf(this.getRows((IModel<String>)stringModel)));
        return editor;
    }

    protected TextAreaWidget createEditorWidget(String id, IModel<String> model) {
        return new CodeMirrorTextAreaWidget(id, model);
    }

    protected int getRows(IModel<String> model) {
        String asString = (String)model.getObject();
        return Math.max(10, asString.length() / 80);
    }
}

