/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.editor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitValue;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceStreamResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;
import org.hippoecm.frontend.dialog.DialogLink;
import org.hippoecm.frontend.dialog.IDialogFactory;
import org.hippoecm.frontend.dialog.IDialogService;
import org.hippoecm.frontend.model.properties.JcrPropertyModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugins.console.dialog.BinaryUploadDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryEditor
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(BinaryEditor.class);
    private static final long ONE_KB = 1024L;
    private static final long ONE_MB = 0x100000L;
    private static final long ONE_GB = 0x40000000L;
    private String contentIdentity = "";

    public BinaryEditor(String id, final JcrPropertyModel model, IPluginContext pluginContext) {
        super(id, (IModel)model);
        BinaryResourceStream stream = new BinaryResourceStream(model);
        ResourceStreamResource resource = new ResourceStreamResource((IResourceStream)stream);
        resource.setCacheDuration(Duration.NONE);
        try {
            Node node = model.getProperty().getParent().getParent();
            StringBuilder fileName = new StringBuilder(node.getName());
            if (BinaryEditor.isExtractedTextProperty(model.getProperty())) {
                fileName.append(".txt");
            }
            resource.setFileName(fileName.toString());
        }
        catch (RepositoryException e) {
            log.error("Unexpected exception while determining download filename", (Throwable)e);
        }
        ResourceLink downloadLink = new ResourceLink("binary-download-lnk", (IResource)resource);
        downloadLink.add(new Component[]{new Label("binary-download-text", "download (" + BinaryEditor.getSizeString(stream.length()) + ")")});
        this.add(new Component[]{downloadLink});
        IDialogFactory factory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public IDialogService.Dialog createDialog() {
                return new BinaryUploadDialog(model);
            }
        };
        IDialogService service = (IDialogService)pluginContext.getService(IDialogService.class.getName(), IDialogService.class);
        DialogLink uploadLink = new DialogLink("binary-upload-link", (IModel)new Model((Serializable)((Object)"Upload binary")), factory, service);
        this.add(new Component[]{uploadLink});
        final Label contentIdentityValueLabel = new Label("content-identity-value", (IModel)new PropertyModel((Object)this, "contentIdentity"));
        contentIdentityValueLabel.setOutputMarkupPlaceholderTag(true);
        contentIdentityValueLabel.setVisible(false);
        this.add(new Component[]{contentIdentityValueLabel});
        AjaxLink contentIdentityShowLink = new AjaxLink("content-identity-show-link"){

            public void onClick(AjaxRequestTarget target) {
                BinaryEditor.this.setContentIdentity(BinaryEditor.this.retrieveJackrabbitContentIdentity());
                target.add(new Component[]{contentIdentityValueLabel.setVisible(true)});
                target.add(new Component[]{this.setVisible(false)});
            }
        };
        this.add(new Component[]{contentIdentityShowLink});
    }

    public String getContentIdentity() {
        return this.contentIdentity;
    }

    public void setContentIdentity(String contentIdentity) {
        this.contentIdentity = contentIdentity;
    }

    private String retrieveJackrabbitContentIdentity() {
        String contentIdentity = "";
        try {
            Value value = ((JcrPropertyModel)this.getDefaultModel()).getProperty().getValue();
            if (value instanceof JackrabbitValue) {
                contentIdentity = ((JackrabbitValue)value).getContentIdentity();
            }
        }
        catch (RepositoryException e) {
            log.error("Failed to get Jackrabbit Binary Value Content Identity.", (Throwable)e);
        }
        return contentIdentity;
    }

    private static String getSizeString(Bytes bytes) {
        if (bytes == null) {
            return "unknown size";
        }
        long length = bytes.bytes();
        String sizeString = length / 0x40000000L > 0L ? String.valueOf(length / 0x40000000L) + " GB" : (length / 0x100000L > 0L ? String.valueOf(length / 0x100000L) + " MB" : (length / 1024L > 0L ? String.valueOf(length / 1024L) + " KB" : String.valueOf(length) + " bytes"));
        return sizeString;
    }

    private static boolean isExtractedTextProperty(Property property) {
        try {
            return property.getName().equals("hippo:text") && BinaryEditor.isPartOfHippoDocument(property);
        }
        catch (RepositoryException e) {
            log.error("Unexpected exception while determining whether property contains extracted text", (Throwable)e);
            return false;
        }
    }

    private static boolean isPartOfHippoDocument(Property property) throws RepositoryException {
        Node root = property.getSession().getRootNode();
        Node current = property.getParent();
        while (!current.isSame((Item)root)) {
            Node parent = current.getParent();
            if (parent.isNodeType("hippo:handle") && current.isNodeType("hippo:document")) {
                return true;
            }
            current = parent;
        }
        return false;
    }

    private static class BinaryResourceStream
    extends AbstractResourceStream {
        private transient InputStream is;
        private JcrPropertyModel model;

        private BinaryResourceStream(JcrPropertyModel model) {
            this.model = model;
        }

        public String getContentType() {
            try {
                if (BinaryEditor.isExtractedTextProperty(this.model.getProperty())) {
                    return "text/plain";
                }
                Node node = this.model.getProperty().getParent();
                return JcrUtils.getStringProperty((Node)node, (String)"jcr:mimeType", (String)"unknown");
            }
            catch (RepositoryException e) {
                log.error("Unexpected exception while determining mime type", (Throwable)e);
                return "unknown";
            }
        }

        public Bytes length() {
            try {
                return Bytes.bytes((long)this.model.getProperty().getLength());
            }
            catch (RepositoryException e) {
                return null;
            }
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            try {
                this.is = this.model.getProperty().getBinary().getStream();
                return this.is;
            }
            catch (RepositoryException e) {
                throw new ResourceStreamNotFoundException((Throwable)e);
            }
        }

        public void close() throws IOException {
            if (this.is != null) {
                IOUtils.closeQuietly((Closeable)this.is);
            }
        }

        public Locale getLocale() {
            return null;
        }

        public void setLocale(Locale locale) {
        }

        public Time lastModifiedTime() {
            try {
                Node node = this.model.getProperty().getParent();
                return Time.valueOf((Date)JcrUtils.getDateProperty((Node)node, (String)"jcr:lastModified", (Calendar)Calendar.getInstance()).getTime());
            }
            catch (RepositoryException e) {
                log.error("Unexpected exception while determining last modified date", (Throwable)e);
                return Time.valueOf((Date)new Date());
            }
        }
    }
}

