/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.browser;

import java.util.Collection;
import javax.swing.tree.TreeNode;
import org.apache.wicket.extensions.markup.html.tree.ITreeState;
import org.apache.wicket.util.io.IClusterable;

public class TreeNavigator
implements IClusterable {
    private final ITreeState treeState;

    public TreeNavigator(ITreeState state) {
        this.treeState = state;
    }

    private TreeNode getSelectedNode() {
        Collection selectedNodes = this.treeState.getSelectedNodes();
        if (selectedNodes.size() != 1) {
            return null;
        }
        return (TreeNode)selectedNodes.iterator().next();
    }

    public void up() {
        TreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        TreeNode parent = node.getParent();
        if (parent != null) {
            TreeNode newSelection;
            int nodeIndex = parent.getIndex(node);
            if (nodeIndex > 0) {
                TreeNode candidate;
                newSelection = parent.getChildAt(nodeIndex - 1);
                while (this.treeState.isNodeExpanded((Object)newSelection) && newSelection.getChildCount() > 0 && !(candidate = newSelection.getChildAt(newSelection.getChildCount() - 1)).equals(node)) {
                    newSelection = candidate;
                }
            } else {
                newSelection = parent;
            }
            this.treeState.selectNode((Object)newSelection, true);
        }
    }

    public void down() {
        TreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        TreeNode newSelection = null;
        if (this.treeState.isNodeExpanded((Object)node) && node.getChildCount() > 0) {
            newSelection = node.getChildAt(0);
        } else {
            TreeNode parent;
            while (newSelection == null && (parent = node.getParent()) != null) {
                int nodeIndex = parent.getIndex(node);
                if (nodeIndex < parent.getChildCount() - 1) {
                    newSelection = parent.getChildAt(nodeIndex + 1);
                    continue;
                }
                node = parent;
            }
        }
        if (newSelection != null) {
            this.treeState.selectNode((Object)newSelection, true);
        }
    }

    public void left() {
        TreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (this.treeState.isNodeExpanded((Object)node)) {
            this.treeState.collapseNode((Object)node);
        } else if (node.getParent() != null) {
            this.treeState.selectNode((Object)node.getParent(), true);
        }
    }

    public void right() {
        TreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        if (!this.treeState.isNodeExpanded((Object)node)) {
            this.treeState.expandNode((Object)node);
        } else if (node.getChildCount() > 0) {
            this.treeState.selectNode((Object)node.getChildAt(0), true);
        }
    }
}

