/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.hippoecm.frontend.model.SystemInfoDataProvider;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopPlugin
extends RenderPlugin {
    private static final Logger log = LoggerFactory.getLogger(TopPlugin.class);
    private static final String BAR_STYLES = "bar.styles";
    private static final String BAR_STYLE_URLPARTS = "bar.style.urlparts";
    private static final SystemInfoDataProvider SYSTEM_INFO = new SystemInfoDataProvider();

    public TopPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        WebMarkupContainer logo = new WebMarkupContainer("logo");
        logo.add(new Behavior[]{TitleAttribute.set((String)("Hippo Release Version: " + SYSTEM_INFO.getReleaseVersion()))});
        this.add(new Component[]{logo});
        WebComponent toolbar = new WebComponent(BAR_STYLES);
        String style = this.obtainBreadcrumbStyle(config);
        if (StringUtils.isNotBlank((String)style)) {
            toolbar.add(new Behavior[]{AttributeModifier.replace((String)"style", (Serializable)((Object)style))});
        }
        this.add(new Component[]{toolbar});
    }

    public String obtainBreadcrumbStyle(IPluginConfig config) {
        String[] urlParts = config.getStringArray(BAR_STYLE_URLPARTS);
        String[] barStyles = config.getStringArray(BAR_STYLES);
        if (urlParts == null || barStyles == null) {
            return null;
        }
        if (urlParts.length != barStyles.length) {
            log.warn("Number of values on the properties \"{}\" and \"{}\" must be equal on {}", new Object[]{BAR_STYLES, BAR_STYLE_URLPARTS, config});
            return null;
        }
        String requestUrl = this.getRequestUrl();
        if (requestUrl != null) {
            for (int i = 0; i < urlParts.length; ++i) {
                String urlPart = urlParts[i];
                String barStyle = barStyles[i];
                if (!StringUtils.isNotEmpty((String)urlPart) || !requestUrl.contains(urlPart) || !StringUtils.isNotBlank((String)barStyle)) continue;
                return barStyle;
            }
        }
        return null;
    }

    private String getRequestUrl() {
        Object request = this.getRequest().getContainerRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getRequestURL().toString();
        }
        return null;
    }
}

