/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console;

import javax.jcr.Node;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.ResourceLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.PluginRequestTarget;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.ModelReference;
import org.hippoecm.frontend.model.event.IObserver;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.cms.logout.ActiveLogoutPlugin;
import org.hippoecm.frontend.plugins.console.ConsoleHeaderItem;
import org.hippoecm.frontend.plugins.console.behavior.ParameterHistoryBehavior;
import org.hippoecm.frontend.plugins.yui.layout.PageLayoutBehavior;
import org.hippoecm.frontend.plugins.yui.layout.PageLayoutSettings;
import org.hippoecm.frontend.plugins.yui.webapp.WebAppBehavior;
import org.hippoecm.frontend.plugins.yui.webapp.WebAppSettings;
import org.hippoecm.frontend.service.ILogoutService;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.hippoecm.frontend.useractivity.UserActivityHeaderItem;
import org.hippoecm.frontend.util.MappingException;
import org.hippoecm.frontend.util.PluginConfigMapper;
import org.hippoecm.frontend.util.WebApplicationHelper;
import org.hippoecm.frontend.widgets.Pinger;

public class RootPlugin
extends RenderPlugin {
    public static final String CONFIG_PINGER_INTERVAL = "pinger.interval";
    public static final String CONFIG_MAX_INACTIVE_INTERVAL_MINUTES = "max.inactive.interval.minutes";
    private boolean rendered = false;
    private ParameterHistoryBehavior parameterHistoryBehavior;

    public RootPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        this.addPinger();
        this.addActiveLogout();
        if (config.getString("wicket.model") != null) {
            String modelId = config.getString("wicket.model");
            ModelReference modelService = new ModelReference(modelId, (IModel)new JcrNodeModel("/"));
            modelService.init(context);
            this.parameterHistoryBehavior = new ParameterHistoryBehavior((IModelReference<Node>)modelService);
            context.registerService((IClusterable)this.parameterHistoryBehavior, IObserver.class.getName());
            this.add(new Behavior[]{this.parameterHistoryBehavior});
        }
        PageLayoutSettings plSettings = new PageLayoutSettings();
        try {
            PluginConfigMapper.populate((Object)plSettings, (IValueMap)config.getPluginConfig((Object)"yui.config"));
        }
        catch (MappingException e) {
            throw new RuntimeException(e);
        }
        this.add(new Behavior[]{new PageLayoutBehavior(plSettings)});
        this.add(new Component[]{new Label("pageTitle", this.getPageTitle(config))});
        String faviconPath = config.getString("favicon.path", "console-red.ico");
        this.add(new Component[]{new ResourceLink("faviconLink", (ResourceReference)new PackageResourceReference(RootPlugin.class, faviconPath))});
    }

    private void addPinger() {
        Duration pingerInterval = this.getPluginConfig().getAsDuration(CONFIG_PINGER_INTERVAL);
        this.add(new Component[]{new Pinger("pinger", pingerInterval)});
    }

    private void addActiveLogout() {
        ILogoutService logoutService = (ILogoutService)this.getPluginContext().getService("hippo-logout-service", ILogoutService.class);
        this.add(new Component[]{new ActiveLogoutPlugin("activeLogout", this.getMaxInactiveIntervalMinutes().intValue(), logoutService)});
    }

    private Integer getMaxInactiveIntervalMinutes() {
        return this.getPluginConfig().getAsInteger(CONFIG_MAX_INACTIVE_INTERVAL_MINUTES, WebApplicationHelper.getMaxInactiveIntervalMinutes());
    }

    public void render(PluginRequestTarget target) {
        if (!this.rendered) {
            WebAppSettings settings = new WebAppSettings();
            this.getPage().add(new Behavior[]{new WebAppBehavior(settings)});
            this.rendered = true;
        }
        super.render(target);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)ConsoleHeaderItem.get());
        response.render((HeaderItem)new UserActivityHeaderItem(this.getMaxInactiveIntervalMinutes().intValue()));
    }

    private String getPageTitle(IPluginConfig config) {
        StringBuilder pageTitle = new StringBuilder(config.getString("page.title", "Hippo CMS Console"));
        if (config.getAsBoolean("page.title.showservername", false)) {
            pageTitle.append(config.getString("page.title.separator", "@"));
            pageTitle.append(this.getServerName());
        }
        return pageTitle.toString();
    }

    private String getServerName() {
        Object request = this.getRequest().getContainerRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getServerName();
        }
        return "";
    }
}

