/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.name;

import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.AbstractPath;
import org.apache.jackrabbit.spi.commons.name.CurrentPath;
import org.apache.jackrabbit.spi.commons.name.RelativePath;

public class CargoNamePath
extends RelativePath {
    private static final long serialVersionUID = -2887665244213430950L;
    private final Name name;
    private final int index;
    private final String argument;

    public CargoNamePath(Path parent, Name name, String argument) {
        super(parent);
        assert (name != null);
        this.name = name;
        this.index = 0;
        this.argument = argument;
    }

    @Override
    protected int getDepthModifier() {
        return 1;
    }

    @Override
    protected Path getParent() throws RepositoryException {
        if (this.parent != null) {
            return this.parent;
        }
        return new CurrentPath(null);
    }

    @Override
    protected String getElementString() {
        if (this.index > 1) {
            return this.name + "[" + this.index + "]";
        }
        return this.name.toString();
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public int getIndex() {
        return 1;
    }

    @Override
    public String getIdentifier() {
        return this.argument;
    }

    @Override
    public boolean denotesIdentifier() {
        return true;
    }

    @Override
    public String getString() {
        return this.name + "[[" + this.argument + "]]";
    }

    @Override
    public int getNormalizedIndex() {
        return 1;
    }

    @Override
    public boolean denotesName() {
        return true;
    }

    public boolean isCanonical() {
        return this.parent != null && this.parent.isCanonical();
    }

    public boolean isNormalized() {
        return this.parent == null || this.parent.isNormalized() && !this.parent.denotesCurrent();
    }

    public Path getNormalizedPath() throws RepositoryException {
        if (this.isNormalized()) {
            return this;
        }
        Path normalized = this.parent.getNormalizedPath();
        if (normalized.denotesCurrent()) {
            normalized = null;
        }
        return new CargoNamePath(normalized, this.name, this.argument);
    }

    public Path getCanonicalPath() throws RepositoryException {
        if (this.isCanonical()) {
            return this;
        }
        if (this.parent != null) {
            return new CargoNamePath(this.parent.getCanonicalPath(), this.name, this.argument);
        }
        throw new RepositoryException("There is no canonical representation of " + this);
    }

    @Override
    public AbstractPath getLastElement() {
        if (this.parent != null) {
            return new CargoNamePath(null, this.name, this.argument);
        }
        return this;
    }

    @Override
    public final boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof Path) {
            Path path = (Path)that;
            return path.denotesName() && this.name.equals(path.getName()) && this.getNormalizedIndex() == path.getNormalizedIndex() && super.equals(that);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return super.hashCode() * 37 + this.name.hashCode() + this.getNormalizedIndex();
    }
}

