/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.EncodingUtils;

public final class SearchInputParsingUtils {
    private static final String FQCN = SearchInputParsingUtils.class.getName();
    private static final String WHITESPACE_PATTERN = "\\s+";

    private SearchInputParsingUtils() {
    }

    public static String parse(String input, boolean allowSingleNonLeadingWildCardPerTerm) {
        if (input == null) {
            return null;
        }
        String parsed = SearchInputParsingUtils.compressWhitespace(input);
        parsed = SearchInputParsingUtils.removeInvalidAndEscapeChars(parsed, allowSingleNonLeadingWildCardPerTerm);
        parsed = SearchInputParsingUtils.removeLeadingOrTrailingOrOperator(parsed);
        parsed = SearchInputParsingUtils.rewriteNotOperatorsToMinus(parsed);
        parsed = SearchInputParsingUtils.removeLeadingAndTrailingAndReplaceWithSpaceAndOperators(parsed);
        parsed = EncodingUtils.foldToASCIIReplacer((String)parsed);
        HstServices.getLogger((String)FQCN, (String)FQCN).debug("Rewrote input '{}' to '{}'", (Object)input, (Object)parsed);
        return parsed;
    }

    public static String parse(String input, boolean allowSingleNonLeadingWildCardPerTerm, int maxLength) {
        if (input == null) {
            return null;
        }
        String parsed = SearchInputParsingUtils.parse(input, allowSingleNonLeadingWildCardPerTerm);
        if (parsed.length() > maxLength) {
            parsed = parsed.substring(0, maxLength);
        }
        HstServices.getLogger((String)FQCN, (String)FQCN).debug("Rewrote input '{}' to '{}'", (Object)input, (Object)parsed);
        return parsed;
    }

    public static String removeLeadingWildCardsFromWords(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is not allowed to be null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '*' || c == '?') {
                char prevChar;
                if (sb.length() <= 0 || (prevChar = sb.charAt(sb.length() - 1)) == '\"' || prevChar == '\'' || prevChar == ' ') continue;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        String output = sb.toString();
        if (!input.equals(output)) {
            HstServices.getLogger((String)FQCN, (String)FQCN).debug("Rewrote input '{}' to '{}'", (Object)input, (Object)output);
        }
        return output;
    }

    public static String removeInvalidAndEscapeChars(String input, boolean allowSingleNonLeadingWildCardPerTerm) {
        if (input == null) {
            throw new IllegalArgumentException("Input is not allowed to be null");
        }
        StringBuffer sb = new StringBuffer();
        boolean allowWildCardInCurrentTerm = allowSingleNonLeadingWildCardPerTerm;
        boolean prevCharIsSpecialOrRemoved = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (SearchInputParsingUtils.isSpecialChar(c)) {
                if (c == '\"') {
                    sb.append('\\');
                    sb.append(c);
                } else if (c != '\'') {
                    char prevChar;
                    if (c == ' ') {
                        allowWildCardInCurrentTerm = allowSingleNonLeadingWildCardPerTerm;
                        sb.append(c);
                    } else if (c == '~' || c == '!' || c == '-') {
                        if (sb.length() == 0) {
                            if (SearchInputParsingUtils.containsNextCharAndIsNotSpecial(input, i)) {
                                sb.append(c);
                            }
                        } else {
                            prevChar = sb.charAt(sb.length() - 1);
                            if (prevChar == ' ') {
                                sb.append(c);
                            } else if (c == '-' && SearchInputParsingUtils.containsNextCharAndIsNotSpecial(input, i)) {
                                sb.append(c);
                            }
                        }
                    } else if (sb.length() > 0 && (c == '*' || c == '?') && allowWildCardInCurrentTerm && !prevCharIsSpecialOrRemoved && (prevChar = sb.charAt(sb.length() - 1)) != '\"' && prevChar != '\'' && prevChar != ' ') {
                        sb.append(c);
                        allowWildCardInCurrentTerm = false;
                    }
                }
                prevCharIsSpecialOrRemoved = true;
                continue;
            }
            sb.append(c);
            prevCharIsSpecialOrRemoved = false;
        }
        String output = sb.toString();
        if (!input.equals(output)) {
            HstServices.getLogger((String)FQCN, (String)FQCN).debug("Rewrote input '{}' to '{}'", (Object)input, (Object)output);
        }
        return output;
    }

    private static boolean containsNextCharAndIsNotSpecial(String input, int cursor) {
        return input.length() > cursor + 1 && !SearchInputParsingUtils.isSpecialChar(input.charAt(cursor + 1));
    }

    public static boolean isSpecialChar(char c) {
        return c == '(' || c == ')' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == '!' || c == '-' || c == '\"' || c == '\'' || c == ' ';
    }

    private static String rewriteNotOperatorsToMinus(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is not allowed to be null");
        }
        return input.replace("NOT ", "-");
    }

    private static String removeLeadingAndTrailingAndReplaceWithSpaceAndOperators(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is not allowed to be null");
        }
        String output = input;
        output = StringUtils.removeStart((String)output, (String)"AND ");
        output = StringUtils.removeEnd((String)output, (String)" AND");
        return output.replace(" AND ", " ");
    }

    public static String removeLeadingOrTrailingOrOperator(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is not allowed to be null");
        }
        String output = input;
        output = StringUtils.removeStart((String)output, (String)"OR ");
        output = StringUtils.removeEnd((String)output, (String)" OR");
        return output;
    }

    public static String compressWhitespace(String text) {
        if (text == null) {
            return null;
        }
        String trimmedText = StringUtils.trim((String)text);
        return trimmedText.replaceAll(WHITESPACE_PATTERN, " ");
    }
}

