/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hippoecm.hst.content.beans.Node;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.manager.ObjectConverterImpl;
import org.hippoecm.hst.content.beans.standard.HippoAsset;
import org.hippoecm.hst.content.beans.standard.HippoAvailableTranslations;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoDirectory;
import org.hippoecm.hst.content.beans.standard.HippoDocument;
import org.hippoecm.hst.content.beans.standard.HippoFacetSelect;
import org.hippoecm.hst.content.beans.standard.HippoFixedDirectory;
import org.hippoecm.hst.content.beans.standard.HippoFolder;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImage;
import org.hippoecm.hst.content.beans.standard.HippoGalleryImageSet;
import org.hippoecm.hst.content.beans.standard.HippoHtml;
import org.hippoecm.hst.content.beans.standard.HippoMirror;
import org.hippoecm.hst.content.beans.standard.HippoResource;
import org.hippoecm.hst.content.beans.standard.HippoStdPubWfRequest;
import org.hippoecm.hst.content.beans.standard.HippoTranslation;
import org.hippoecm.hst.content.beans.standard.facetnavigation.HippoFacetNavigation;
import org.hippoecm.hst.content.beans.standard.facetnavigation.HippoFacetResult;
import org.hippoecm.hst.content.beans.standard.facetnavigation.HippoFacetSearch;
import org.hippoecm.hst.content.beans.standard.facetnavigation.HippoFacetSubNavigation;
import org.hippoecm.hst.content.beans.standard.facetnavigation.HippoFacetsAvailableNavigation;
import org.hippoecm.hst.util.ClasspathResourceScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ObjectConverterUtils {
    private static Logger log = LoggerFactory.getLogger(ObjectConverterUtils.class);
    private static final Class<?>[] DEFAULT_BUILT_IN_MAPPING_CLASSES = new Class[]{HippoDocument.class, HippoFolder.class, HippoMirror.class, HippoFacetSelect.class, HippoDirectory.class, HippoFixedDirectory.class, HippoHtml.class, HippoResource.class, HippoStdPubWfRequest.class, HippoAsset.class, HippoGalleryImageSet.class, HippoGalleryImage.class, HippoTranslation.class, HippoFacetSearch.class, HippoFacetNavigation.class, HippoFacetsAvailableNavigation.class, HippoFacetSubNavigation.class, HippoFacetResult.class, HippoAvailableTranslations.class};
    private static final String[] DEFAULT_FALLBACK_NODE_TYPES = new String[]{"hippo:facetselect", "hippo:mirror", "hippostd:directory", "hippostd:folder", "hippogallery:image", "hippo:resource", "hippo:request", "hippostd:html", "hippo:document"};

    private ObjectConverterUtils() {
    }

    public static ObjectConverter createObjectConverter(Collection<Class<? extends HippoBean>> annotatedClasses) throws IllegalArgumentException {
        return ObjectConverterUtils.createObjectConverter(annotatedClasses, false);
    }

    public static ObjectConverter createObjectConverter(Collection<Class<? extends HippoBean>> annotatedClasses, boolean ignoreDuplicates) throws IllegalArgumentException {
        return ObjectConverterUtils.createObjectConverter(annotatedClasses, DEFAULT_BUILT_IN_MAPPING_CLASSES, DEFAULT_FALLBACK_NODE_TYPES, ignoreDuplicates);
    }

    public static ObjectConverter createObjectConverter(Collection<Class<? extends HippoBean>> annotatedClasses, Class<? extends HippoBean>[] builtInMappingClasses, String[] fallbackNodeTypes, boolean ignoreDuplicates) throws IllegalArgumentException {
        HashMap<String, Class<? extends HippoBean>> jcrPrimaryNodeTypeClassPairs = new HashMap<String, Class<? extends HippoBean>>();
        if (annotatedClasses != null && !annotatedClasses.isEmpty()) {
            for (Class<? extends HippoBean> c : annotatedClasses) {
                ObjectConverterUtils.addJcrPrimaryNodeTypeClassPair(jcrPrimaryNodeTypeClassPairs, c, false, ignoreDuplicates);
            }
        }
        if (builtInMappingClasses != null) {
            for (Class<? extends HippoBean> clazz : builtInMappingClasses) {
                ObjectConverterUtils.addJcrPrimaryNodeTypeClassPair(jcrPrimaryNodeTypeClassPairs, clazz, true, ignoreDuplicates);
            }
        }
        return new ObjectConverterImpl(jcrPrimaryNodeTypeClassPairs, fallbackNodeTypes);
    }

    public static String[] getDefaultFallbackNodeTypes() {
        String[] fallbackTypes = new String[DEFAULT_FALLBACK_NODE_TYPES.length];
        System.arraycopy(DEFAULT_FALLBACK_NODE_TYPES, 0, fallbackTypes, 0, DEFAULT_FALLBACK_NODE_TYPES.length);
        return fallbackTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Class<? extends HippoBean>> getAnnotatedClasses(URL url) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<Class<? extends HippoBean>> annotatedClasses = new ArrayList<Class<? extends HippoBean>>();
        InputStream is = null;
        BufferedInputStream bis = null;
        try {
            is = url.openStream();
            bis = new BufferedInputStream(is);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bis);
            Element root = document.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("annotated-class");
            int size = nodeList.getLength();
            Element elem = null;
            String className = null;
            Class<?> clazz = null;
            for (int i = 0; i < size; ++i) {
                elem = (Element)nodeList.item(i);
                className = elem.getTextContent().trim();
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("Skipped class registration into the mapper. Cannot load class: {}.", (Object)className);
                }
                if (HippoBean.class.isAssignableFrom(clazz)) {
                    annotatedClasses.add(clazz);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Skipped class registration into the mapper. Type is not HippoBean: {}.", (Object)className);
            }
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ignore) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ignore) {}
            }
        }
        return annotatedClasses;
    }

    public static List<Class<? extends HippoBean>> getAnnotatedClasses(ClasspathResourceScanner resourceScanner, String ... locationPatterns) throws IOException, SAXException, ParserConfigurationException {
        ArrayList<Class<? extends HippoBean>> annotatedClasses = new ArrayList<Class<? extends HippoBean>>();
        Set annotatedClassNames = resourceScanner.scanClassNamesAnnotatedBy(Node.class, false, locationPatterns);
        if (annotatedClassNames != null && !annotatedClassNames.isEmpty()) {
            Class<?> clazz = null;
            for (String className : annotatedClassNames) {
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    log.warn("ObjectConverterUtils skipped annotated class registration. The class cannot be loaded: {}.", (Object)className);
                    continue;
                }
                int mod = clazz.getModifiers();
                if (!Modifier.isPublic(mod)) {
                    log.warn("ObjectConverterUtils skipped annotated class registration. The class must be a *public* class: {}.", (Object)className);
                    continue;
                }
                if (HippoBean.class.isAssignableFrom(clazz)) {
                    annotatedClasses.add(clazz);
                    continue;
                }
                log.warn("ObjectConverterUtils skipped annotated class registration. The class must be type of {}: {}.", HippoBean.class, (Object)className);
            }
        }
        return annotatedClasses;
    }

    private static void addJcrPrimaryNodeTypeClassPair(Map<String, Class<? extends HippoBean>> jcrPrimaryNodeTypeClassPairs, Class<? extends HippoBean> clazz, boolean builtinType, boolean ignoreDuplicates) throws IllegalArgumentException {
        String jcrPrimaryNodeType = null;
        if (clazz.isAnnotationPresent(Node.class)) {
            Node anno = clazz.getAnnotation(Node.class);
            jcrPrimaryNodeType = anno.jcrType();
        }
        if (jcrPrimaryNodeType == null) {
            throw new IllegalArgumentException("There's no annotation for jcrType in the class: " + clazz);
        }
        if (jcrPrimaryNodeTypeClassPairs.containsKey(jcrPrimaryNodeType)) {
            if (builtinType) {
                log.debug("Builtin annotated class '{}' for primary type '{}' is overridden with already registered class '{}'. Builtin version is ignored.", new Object[]{clazz.getName(), jcrPrimaryNodeType, jcrPrimaryNodeTypeClassPairs.get(jcrPrimaryNodeType).getName()});
            } else if (ignoreDuplicates) {
                log.debug("Duplicate annotated class '{}' found for primary type '{}'. The already registered class '{}' is preserved.", new Object[]{clazz.getName(), jcrPrimaryNodeType, jcrPrimaryNodeTypeClassPairs.get(jcrPrimaryNodeType).getName()});
            } else {
                throw new IllegalArgumentException("Annotated class '" + clazz.getName() + "' for primarytype '" + jcrPrimaryNodeType + "' is a duplicate of already registered class '" + jcrPrimaryNodeTypeClassPairs.get(jcrPrimaryNodeType).getName() + "'. " + "You might have configured a bean that does not have a annotation for the jcrType and " + "inherits the jcrType from the bean it extends, resulting in 2 beans with the same jcrType. Correct your beans.");
            }
            return;
        }
        jcrPrimaryNodeTypeClassPairs.put(jcrPrimaryNodeType, clazz);
    }
}

