/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.util;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.content.beans.manager.ObjectConverter;
import org.hippoecm.hst.content.beans.query.HstQuery;
import org.hippoecm.hst.content.beans.query.HstQueryResult;
import org.hippoecm.hst.content.beans.query.exceptions.FilterException;
import org.hippoecm.hst.content.beans.query.exceptions.QueryException;
import org.hippoecm.hst.content.beans.query.filter.BaseFilter;
import org.hippoecm.hst.content.beans.query.filter.Filter;
import org.hippoecm.hst.content.beans.standard.HippoBean;
import org.hippoecm.hst.content.beans.standard.HippoBeanIterator;
import org.hippoecm.hst.content.beans.standard.HippoDocumentBean;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.search.HstQueryManagerFactory;
import org.hippoecm.hst.site.HstServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(ContentBeanUtils.class);

    private ContentBeanUtils() {
    }

    public static boolean isBeanType(Object bean, String typeName) {
        if (bean == null || StringUtils.isEmpty((String)typeName)) {
            return false;
        }
        Class<?> beanType = bean.getClass();
        String beanFqcn = beanType.getName();
        if (StringUtils.equals((String)beanFqcn, (String)typeName)) {
            return true;
        }
        try {
            Class<?> type = Thread.currentThread().getContextClassLoader().loadClass(typeName);
            if (type.isAssignableFrom(bean.getClass())) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            log.debug("Type not found.", (Throwable)e);
            return false;
        }
        return false;
    }

    public static HstQuery createIncomingBeansQuery(HippoDocumentBean bean, HippoBean scope, String linkPath, ObjectConverter converter, Class<? extends HippoBean> beanMappingClass, boolean includeSubTypes) throws QueryException {
        ArrayList<String> linkPaths = new ArrayList<String>();
        linkPaths.add(linkPath);
        return ContentBeanUtils.createIncomingBeansQuery(bean, scope, linkPaths, converter, beanMappingClass, includeSubTypes);
    }

    public static HstQuery createIncomingBeansQuery(HippoDocumentBean bean, HippoBean scope, int depth, ObjectConverter converter, Class<? extends HippoBean> beanMappingClass, boolean includeSubTypes) throws QueryException {
        if (depth < 0 || depth > 4) {
            throw new FilterException("Depth must be (including) between 0 and 4");
        }
        String path = "@hippo:docbase";
        ArrayList<String> linkPaths = new ArrayList<String>();
        linkPaths.add(path);
        for (int i = 1; i <= depth; ++i) {
            path = "*/" + path;
            linkPaths.add(path);
        }
        return ContentBeanUtils.createIncomingBeansQuery(bean, scope, linkPaths, converter, beanMappingClass, includeSubTypes);
    }

    public static HstQuery createIncomingBeansQuery(HippoDocumentBean bean, HippoBean scope, List<String> linkPaths, ObjectConverter converter, Class<? extends HippoBean> beanMappingClass, boolean includeSubTypes) throws QueryException {
        String canonicalHandleUUID = bean.getCanonicalHandleUUID();
        try {
            ComponentManager compMngr = HstServices.getComponentManager();
            HstQueryManagerFactory hstQueryManagerFactory = (HstQueryManagerFactory)compMngr.getComponent(HstQueryManagerFactory.class.getName());
            HstQuery query = hstQueryManagerFactory.createQueryManager(bean.getNode().getSession(), converter).createQuery(scope, beanMappingClass, includeSubTypes);
            Filter filter = query.createFilter();
            for (String linkPath : linkPaths) {
                Filter orFilter = query.createFilter();
                orFilter.addEqualTo(linkPath, (Object)canonicalHandleUUID);
                filter.addOrFilter((BaseFilter)orFilter);
            }
            query.setFilter((BaseFilter)filter);
            return query;
        }
        catch (RepositoryException e) {
            throw new QueryException("RepositoryException", (Throwable)e);
        }
    }

    public static <T extends HippoBean> List<T> getIncomingBeans(HstQuery query, Class<? extends HippoBean> beanMappingClass) throws QueryException {
        ArrayList<HippoBean> incomingBeans = new ArrayList<HippoBean>();
        HstQueryResult result = query.execute();
        HippoBeanIterator beans = result.getHippoBeans();
        while (beans.hasNext()) {
            HippoBean incomingBean = beans.nextHippoBean();
            if (incomingBean == null) continue;
            if (!beanMappingClass.isAssignableFrom(incomingBean.getClass())) {
                log.warn("Found a bean not being of type or subtype of '{}'. Skip bean", (Object)beanMappingClass.getName());
                continue;
            }
            incomingBeans.add(incomingBean);
        }
        return incomingBeans;
    }
}

